/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer.operators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.flink.optimizer.dag.TwoInputNode;
import org.apache.flink.optimizer.dataproperties.GlobalProperties;
import org.apache.flink.optimizer.dataproperties.LocalProperties;
import org.apache.flink.optimizer.dataproperties.PartitioningProperty;
import org.apache.flink.optimizer.dataproperties.RequestedGlobalProperties;
import org.apache.flink.optimizer.dataproperties.RequestedLocalProperties;
import org.apache.flink.optimizer.operators.OperatorDescriptorDual;
import org.apache.flink.optimizer.plan.Channel;
import org.apache.flink.optimizer.plan.DualInputPlanNode;

public abstract class CartesianProductDescriptor
extends OperatorDescriptorDual {
    private final boolean allowBroadcastFirst;
    private final boolean allowBroadcastSecond;

    protected CartesianProductDescriptor(boolean allowBroadcastFirst, boolean allowBroadcastSecond) {
        if (!(allowBroadcastFirst | allowBroadcastSecond)) {
            throw new IllegalArgumentException();
        }
        this.allowBroadcastFirst = allowBroadcastFirst;
        this.allowBroadcastSecond = allowBroadcastSecond;
    }

    @Override
    protected List<OperatorDescriptorDual.GlobalPropertiesPair> createPossibleGlobalProperties() {
        ArrayList<OperatorDescriptorDual.GlobalPropertiesPair> pairs = new ArrayList<OperatorDescriptorDual.GlobalPropertiesPair>();
        if (this.allowBroadcastFirst) {
            RequestedGlobalProperties replicated1 = new RequestedGlobalProperties();
            replicated1.setFullyReplicated();
            RequestedGlobalProperties any2 = new RequestedGlobalProperties();
            pairs.add(new OperatorDescriptorDual.GlobalPropertiesPair(replicated1, any2));
        }
        if (this.allowBroadcastSecond) {
            RequestedGlobalProperties any1 = new RequestedGlobalProperties();
            RequestedGlobalProperties replicated2 = new RequestedGlobalProperties();
            replicated2.setFullyReplicated();
            pairs.add(new OperatorDescriptorDual.GlobalPropertiesPair(any1, replicated2));
        }
        return pairs;
    }

    @Override
    protected List<OperatorDescriptorDual.LocalPropertiesPair> createPossibleLocalProperties() {
        return Collections.singletonList(new OperatorDescriptorDual.LocalPropertiesPair(new RequestedLocalProperties(), new RequestedLocalProperties()));
    }

    @Override
    public boolean areCompatible(RequestedGlobalProperties requested1, RequestedGlobalProperties requested2, GlobalProperties produced1, GlobalProperties produced2) {
        return true;
    }

    @Override
    public boolean areCoFulfilled(RequestedLocalProperties requested1, RequestedLocalProperties requested2, LocalProperties produced1, LocalProperties produced2) {
        return true;
    }

    @Override
    public DualInputPlanNode instantiate(Channel in1, Channel in2, TwoInputNode node) {
        return new DualInputPlanNode(node, "Cross(" + node.getOperator().getName() + ")", in1, in2, this.getStrategy());
    }

    @Override
    public GlobalProperties computeGlobalProperties(GlobalProperties in1, GlobalProperties in2) {
        GlobalProperties gp = GlobalProperties.combine(in1, in2);
        if (gp.getUniqueFieldCombination() != null && gp.getUniqueFieldCombination().size() > 0 && gp.getPartitioning() == PartitioningProperty.RANDOM_PARTITIONED) {
            gp.setAnyPartitioning(gp.getUniqueFieldCombination().iterator().next().toFieldList());
        }
        gp.clearUniqueFieldCombinations();
        return gp;
    }
}

