/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer.operators;

import java.util.Collections;
import java.util.List;
import org.apache.flink.api.common.operators.util.FieldList;
import org.apache.flink.optimizer.CompilerException;
import org.apache.flink.optimizer.dag.TwoInputNode;
import org.apache.flink.optimizer.dataproperties.LocalProperties;
import org.apache.flink.optimizer.dataproperties.RequestedLocalProperties;
import org.apache.flink.optimizer.operators.AbstractJoinDescriptor;
import org.apache.flink.optimizer.operators.OperatorDescriptorDual;
import org.apache.flink.optimizer.plan.Channel;
import org.apache.flink.optimizer.plan.DualInputPlanNode;
import org.apache.flink.runtime.operators.DriverStrategy;

public class HashJoinBuildFirstProperties
extends AbstractJoinDescriptor {
    public HashJoinBuildFirstProperties(FieldList keys1, FieldList keys2) {
        super(keys1, keys2);
    }

    public HashJoinBuildFirstProperties(FieldList keys1, FieldList keys2, boolean broadcastFirstAllowed, boolean broadcastSecondAllowed, boolean repartitionAllowed) {
        super(keys1, keys2, broadcastFirstAllowed, broadcastSecondAllowed, repartitionAllowed);
    }

    @Override
    public DriverStrategy getStrategy() {
        return DriverStrategy.HYBRIDHASH_BUILD_FIRST;
    }

    @Override
    protected List<OperatorDescriptorDual.LocalPropertiesPair> createPossibleLocalProperties() {
        return Collections.singletonList(new OperatorDescriptorDual.LocalPropertiesPair(new RequestedLocalProperties(), new RequestedLocalProperties()));
    }

    @Override
    public boolean areCoFulfilled(RequestedLocalProperties requested1, RequestedLocalProperties requested2, LocalProperties produced1, LocalProperties produced2) {
        return true;
    }

    @Override
    public DualInputPlanNode instantiate(Channel in1, Channel in2, TwoInputNode node) {
        DriverStrategy strategy;
        if (!in1.isOnDynamicPath() && in2.isOnDynamicPath()) {
            if (!in1.getTempMode().isCached()) {
                throw new CompilerException("No cache at point where static and dynamic parts meet.");
            }
            in1.setTempMode(in1.getTempMode().makeNonCached());
            strategy = DriverStrategy.HYBRIDHASH_BUILD_FIRST_CACHED;
        } else {
            strategy = DriverStrategy.HYBRIDHASH_BUILD_FIRST;
        }
        return new DualInputPlanNode(node, "Join(" + node.getOperator().getName() + ")", in1, in2, strategy, this.keys1, this.keys2);
    }

    @Override
    public LocalProperties computeLocalProperties(LocalProperties in1, LocalProperties in2) {
        return new LocalProperties();
    }
}

