/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutorServiceAdapter;
import org.apache.flink.runtime.executiongraph.utils.SimpleAckingTaskManagerGateway;
import org.apache.flink.runtime.jobmanager.slots.TaskManagerGateway;
import org.apache.flink.runtime.jobmaster.SlotRequestId;
import org.apache.flink.runtime.jobmaster.slotpool.DeclarativeSlotPoolBridgeBuilder;
import org.apache.flink.runtime.jobmaster.slotpool.SlotPool;
import org.apache.flink.runtime.jobmaster.slotpool.SlotPoolUtils;
import org.apache.flink.runtime.resourcemanager.ResourceManagerGateway;
import org.apache.flink.runtime.resourcemanager.utils.TestingResourceManagerGateway;
import org.apache.flink.runtime.taskexecutor.slot.SlotOffer;
import org.apache.flink.runtime.taskmanager.LocalTaskManagerLocation;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.TestLogger;
import org.apache.flink.util.function.CheckedSupplier;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;

public class DeclarativeSlotPoolBridgeRequestCompletionTest
extends TestLogger {
    private static final Time TIMEOUT = SlotPoolUtils.TIMEOUT;
    private TestingResourceManagerGateway resourceManagerGateway;

    @Before
    public void setUp() throws Exception {
        this.resourceManagerGateway = new TestingResourceManagerGateway();
    }

    @Test
    public void testRequestsAreCompletedInRequestOrder() {
        this.runSlotRequestCompletionTest(CheckedSupplier.unchecked(this::createAndSetUpSlotPool), slotPool -> {});
    }

    @Test
    public void testStashOrderMaintainsRequestOrder() {
        this.runSlotRequestCompletionTest(CheckedSupplier.unchecked(this::createAndSetUpSlotPoolWithoutResourceManager), this::connectToResourceManager);
    }

    private void runSlotRequestCompletionTest(Supplier<SlotPool> slotPoolSupplier, Consumer<SlotPool> actionAfterSlotRequest) {
        try (SlotPool slotPool = slotPoolSupplier.get();){
            int requestNum = 10;
            List slotRequestIds = IntStream.range(0, 10).mapToObj(ignored -> new SlotRequestId()).collect(Collectors.toList());
            List slotRequests = slotRequestIds.stream().map(slotRequestId -> slotPool.requestNewAllocatedSlot(slotRequestId, ResourceProfile.UNKNOWN, TIMEOUT)).collect(Collectors.toList());
            actionAfterSlotRequest.accept(slotPool);
            LocalTaskManagerLocation taskManagerLocation = new LocalTaskManagerLocation();
            slotPool.registerTaskManager(taskManagerLocation.getResourceID());
            SlotOffer slotOffer = new SlotOffer(new AllocationID(), 0, ResourceProfile.ANY);
            Collection acceptedSlots = slotPool.offerSlots((TaskManagerLocation)taskManagerLocation, (TaskManagerGateway)new SimpleAckingTaskManagerGateway(), Collections.singleton(slotOffer));
            MatcherAssert.assertThat((Object)acceptedSlots, (Matcher)Matchers.containsInAnyOrder((Object[])new SlotOffer[]{slotOffer}));
            FlinkException testingReleaseException = new FlinkException("Testing release exception");
            for (int i = 0; i < slotRequestIds.size(); ++i) {
                CompletableFuture slotRequestFuture = (CompletableFuture)slotRequests.get(i);
                MatcherAssert.assertThat(slotRequestFuture.getNow(null), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
                slotPool.releaseSlot((SlotRequestId)slotRequestIds.get(i), (Throwable)testingReleaseException);
            }
        }
    }

    private SlotPool createAndSetUpSlotPool() throws Exception {
        return new DeclarativeSlotPoolBridgeBuilder().setResourceManagerGateway(this.resourceManagerGateway).buildAndStart(ComponentMainThreadExecutorServiceAdapter.forMainThread());
    }

    private void connectToResourceManager(SlotPool slotPool) {
        slotPool.connectToResourceManager((ResourceManagerGateway)this.resourceManagerGateway);
    }

    private SlotPool createAndSetUpSlotPoolWithoutResourceManager() throws Exception {
        return new DeclarativeSlotPoolBridgeBuilder().setResourceManagerGateway(null).buildAndStart(ComponentMainThreadExecutorServiceAdapter.forMainThread());
    }
}

