/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.util;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MetricOptions;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.memory.MemoryAllocationException;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.metrics.util.InterceptingOperatorMetricGroup;
import org.apache.flink.runtime.metrics.util.MetricUtils;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.rpc.RpcSystem;
import org.apache.flink.runtime.taskexecutor.TaskManagerServices;
import org.apache.flink.runtime.taskexecutor.TaskManagerServicesBuilder;
import org.apache.flink.runtime.taskexecutor.slot.TaskSlotTable;
import org.apache.flink.runtime.taskexecutor.slot.TestingTaskSlotTable;
import org.apache.flink.shaded.guava30.com.google.common.collect.Sets;
import org.apache.flink.testutils.ClassLoaderUtils;
import org.apache.flink.util.ChildFirstClassLoader;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.TestLogger;
import org.apache.flink.util.function.CheckedSupplier;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class MetricUtilsTest
extends TestLogger {
    private final List<Object> referencedObjects = new ArrayList<Object>();

    @After
    public void cleanupReferencedObjects() {
        this.referencedObjects.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartMetricActorSystemRespectsThreadPriority() throws Exception {
        Configuration configuration = new Configuration();
        int expectedThreadPriority = 3;
        configuration.setInteger(MetricOptions.QUERY_SERVICE_THREAD_PRIORITY, 3);
        RpcService rpcService = MetricUtils.startRemoteMetricsRpcService((Configuration)configuration, (String)"localhost", null, (RpcSystem)RpcSystem.load());
        try {
            int threadPriority = (Integer)rpcService.execute(() -> Thread.currentThread().getPriority()).get();
            Assert.assertThat((Object)threadPriority, (Matcher)Matchers.is((Object)3));
        }
        finally {
            rpcService.stopService().get();
        }
    }

    @Test
    public void testNonHeapMetricsCompleteness() {
        InterceptingOperatorMetricGroup nonHeapMetrics = new InterceptingOperatorMetricGroup();
        MetricUtils.instantiateNonHeapMemoryMetrics((MetricGroup)nonHeapMetrics);
        Assert.assertNotNull((Object)nonHeapMetrics.get("Used"));
        Assert.assertNotNull((Object)nonHeapMetrics.get("Committed"));
        Assert.assertNotNull((Object)nonHeapMetrics.get("Max"));
    }

    @Test
    public void testMetaspaceCompleteness() {
        Assume.assumeTrue((String)"Requires JVM with Metaspace memory pool", (boolean)MetricUtilsTest.hasMetaspaceMemoryPool());
        InterceptingOperatorMetricGroup metaspaceMetrics = new InterceptingOperatorMetricGroup(){

            public MetricGroup addGroup(String name) {
                return this;
            }
        };
        MetricUtils.instantiateMetaspaceMemoryMetrics((MetricGroup)metaspaceMetrics);
        Assert.assertNotNull((Object)metaspaceMetrics.get("Used"));
        Assert.assertNotNull((Object)metaspaceMetrics.get("Committed"));
        Assert.assertNotNull((Object)metaspaceMetrics.get("Max"));
    }

    @Test
    public void testHeapMetricsCompleteness() {
        InterceptingOperatorMetricGroup heapMetrics = new InterceptingOperatorMetricGroup();
        MetricUtils.instantiateHeapMemoryMetrics((MetricGroup)heapMetrics);
        Assert.assertNotNull((Object)heapMetrics.get("Used"));
        Assert.assertNotNull((Object)heapMetrics.get("Committed"));
        Assert.assertNotNull((Object)heapMetrics.get("Max"));
    }

    @Test
    public void testHeapMetricUsageNotStatic() throws Exception {
        InterceptingOperatorMetricGroup heapMetrics = new InterceptingOperatorMetricGroup();
        MetricUtils.instantiateHeapMemoryMetrics((MetricGroup)heapMetrics);
        Gauge used = (Gauge)heapMetrics.get("Used");
        this.runUntilMetricChanged("Heap", 10, (CheckedSupplier<Object>)((CheckedSupplier)() -> new byte[0x800000]), (Gauge<Long>)used);
    }

    @Test
    public void testMetaspaceMetricUsageNotStatic() throws Exception {
        Assume.assumeTrue((String)"Requires JVM with Metaspace memory pool", (boolean)MetricUtilsTest.hasMetaspaceMemoryPool());
        InterceptingOperatorMetricGroup metaspaceMetrics = new InterceptingOperatorMetricGroup(){

            public MetricGroup addGroup(String name) {
                return this;
            }
        };
        MetricUtils.instantiateMetaspaceMemoryMetrics((MetricGroup)metaspaceMetrics);
        Gauge used = (Gauge)metaspaceMetrics.get("Used");
        this.runUntilMetricChanged("Metaspace", 10, (CheckedSupplier<Object>)((CheckedSupplier)MetricUtilsTest::redefineDummyClass), (Gauge<Long>)used);
    }

    @Test
    public void testNonHeapMetricUsageNotStatic() throws Exception {
        InterceptingOperatorMetricGroup nonHeapMetrics = new InterceptingOperatorMetricGroup();
        MetricUtils.instantiateNonHeapMemoryMetrics((MetricGroup)nonHeapMetrics);
        Gauge used = (Gauge)nonHeapMetrics.get("Used");
        this.runUntilMetricChanged("Non-heap", 10, (CheckedSupplier<Object>)((CheckedSupplier)MetricUtilsTest::redefineDummyClass), (Gauge<Long>)used);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testManagedMemoryMetricsInitialization() throws MemoryAllocationException, FlinkException {
        int maxMemorySize = 16284;
        int numberOfAllocatedPages = 2;
        int pageSize = 4096;
        Object owner = new Object();
        MemoryManager memoryManager = MemoryManager.create((long)16284L, (int)4096);
        memoryManager.allocatePages(owner, 2);
        TaskManagerServices taskManagerServices = new TaskManagerServicesBuilder().setTaskSlotTable(new TestingTaskSlotTable.TestingTaskSlotTableBuilder().memoryManagerGetterReturns(memoryManager).allActiveSlotAllocationIds(() -> Sets.newHashSet((Object[])new AllocationID[]{new AllocationID()})).build()).setManagedMemorySize(16284L).build();
        try {
            final ArrayList actualSubGroupPath = new ArrayList();
            InterceptingOperatorMetricGroup metricGroup = new InterceptingOperatorMetricGroup(){

                public MetricGroup addGroup(String name) {
                    actualSubGroupPath.add(name);
                    return this;
                }
            };
            MetricUtils.instantiateFlinkMemoryMetricGroup((MetricGroup)metricGroup, (TaskSlotTable)taskManagerServices.getTaskSlotTable(), () -> ((TaskManagerServices)taskManagerServices).getManagedMemorySize());
            Gauge usedMetric = (Gauge)metricGroup.get("Used");
            Gauge maxMetric = (Gauge)metricGroup.get("Total");
            Assert.assertThat((Object)((Number)usedMetric.getValue()).intValue(), (Matcher)Matchers.is((Object)8192));
            Assert.assertThat((Object)((Number)maxMetric.getValue()).intValue(), (Matcher)Matchers.is((Object)16284));
            Assert.assertThat(actualSubGroupPath, (Matcher)Matchers.is(Arrays.asList("Flink", "Memory", "Managed")));
        }
        finally {
            taskManagerServices.shutDown();
        }
    }

    private static Class<?> redefineDummyClass() throws ClassNotFoundException {
        Class<Dummy> clazz = Dummy.class;
        ChildFirstClassLoader classLoader = new ChildFirstClassLoader(ClassLoaderUtils.getClasspathURLs(), clazz.getClassLoader(), new String[]{"java."}, ignored -> {});
        Class newClass = classLoader.loadClass(clazz.getName());
        Assert.assertNotSame(clazz, (Object)newClass);
        Assert.assertEquals((Object)clazz.getName(), (Object)newClass.getName());
        return newClass;
    }

    private static boolean hasMetaspaceMemoryPool() {
        return ManagementFactory.getMemoryPoolMXBeans().stream().anyMatch(bean -> "Metaspace".equals(bean.getName()));
    }

    private void runUntilMetricChanged(String name, int maxRuns, CheckedSupplier<Object> objectCreator, Gauge<Long> metric) throws Exception {
        maxRuns = Math.max(1, maxRuns);
        long initialValue = (Long)metric.getValue();
        for (int i = 0; i < maxRuns; ++i) {
            Object object = objectCreator.get();
            long currentValue = (Long)metric.getValue();
            if (currentValue != initialValue) {
                return;
            }
            this.referencedObjects.add(object);
            Thread.sleep(50L);
        }
        String msg = String.format("%s usage metric never changed its value after %d runs.", name, maxRuns);
        Assert.fail((String)msg);
    }

    private static class Dummy {
        private Dummy() {
        }
    }
}

