/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.testutils.types;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConfigSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerFactory;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.operators.testutils.types.IntPair;

public class IntPairSerializer
extends TypeSerializer<IntPair> {
    private static final long serialVersionUID = 1L;

    public boolean isImmutableType() {
        return false;
    }

    public IntPairSerializer duplicate() {
        return this;
    }

    public IntPair createInstance() {
        return new IntPair();
    }

    public IntPair copy(IntPair from) {
        return new IntPair(from.getKey(), from.getValue());
    }

    public IntPair copy(IntPair from, IntPair reuse) {
        reuse.setKey(from.getKey());
        reuse.setValue(from.getValue());
        return reuse;
    }

    public int getLength() {
        return 8;
    }

    public void serialize(IntPair record, DataOutputView target) throws IOException {
        target.writeInt(record.getKey());
        target.writeInt(record.getValue());
    }

    public IntPair deserialize(DataInputView source) throws IOException {
        return new IntPair(source.readInt(), source.readInt());
    }

    public IntPair deserialize(IntPair reuse, DataInputView source) throws IOException {
        reuse.setKey(source.readInt());
        reuse.setValue(source.readInt());
        return reuse;
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        target.write(source, 8);
    }

    public boolean equals(Object obj) {
        return obj instanceof IntPairSerializer;
    }

    public int hashCode() {
        return IntPairSerializer.class.hashCode();
    }

    public TypeSerializerConfigSnapshot<IntPair> snapshotConfiguration() {
        throw new UnsupportedOperationException();
    }

    public static final class IntPairSerializerFactory
    implements TypeSerializerFactory<IntPair> {
        public void writeParametersToConfig(Configuration config) {
        }

        public void readParametersFromConfig(Configuration config, ClassLoader cl) {
        }

        public IntPairSerializer getSerializer() {
            return new IntPairSerializer();
        }

        public Class<IntPair> getDataType() {
            return IntPair.class;
        }

        public int hashCode() {
            return 42;
        }

        public boolean equals(Object obj) {
            return obj.getClass() == IntPairSerializerFactory.class;
        }
    }
}

