/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rpc;

import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.apache.flink.core.testutils.CustomExtension;
import org.apache.flink.runtime.rpc.TestingRpcService;
import org.apache.flink.util.Preconditions;
import org.junit.jupiter.api.extension.ExtensionContext;

public class TestingRpcServiceExtension
implements CustomExtension {
    @Nullable
    private TestingRpcService testingRpcService = null;

    public TestingRpcService getTestingRpcService() {
        Preconditions.checkNotNull((Object)this.testingRpcService);
        return this.testingRpcService;
    }

    public void before(ExtensionContext extensionContext) {
        if (this.testingRpcService != null) {
            this.terminateRpcService(this.testingRpcService);
        }
        this.testingRpcService = new TestingRpcService();
    }

    public void after(ExtensionContext extensionContext) {
        if (this.testingRpcService != null) {
            this.terminateRpcService(this.testingRpcService);
            this.testingRpcService = null;
        }
    }

    private void terminateRpcService(TestingRpcService testingRpcService) {
        CompletableFuture<Void> terminationFuture = testingRpcService.stopService();
        terminationFuture.join();
    }
}

