/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.strategy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.scheduler.SchedulerOperations;
import org.apache.flink.runtime.scheduler.strategy.ResultPartitionState;
import org.apache.flink.runtime.scheduler.strategy.SchedulingTopology;
import org.apache.flink.runtime.scheduler.strategy.StrategyTestUtil;
import org.apache.flink.runtime.scheduler.strategy.TestingSchedulerOperations;
import org.apache.flink.runtime.scheduler.strategy.TestingSchedulingExecutionVertex;
import org.apache.flink.runtime.scheduler.strategy.TestingSchedulingTopology;
import org.apache.flink.runtime.scheduler.strategy.VertexwiseSchedulingStrategy;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;

public class VertexwiseSchedulingStrategyTest {
    private TestingSchedulerOperations testingSchedulerOperation;
    private static final int PARALLELISM = 2;
    private TestingSchedulingTopology testingSchedulingTopology;
    private List<TestingSchedulingExecutionVertex> source;
    private List<TestingSchedulingExecutionVertex> map;
    private List<TestingSchedulingExecutionVertex> sink;

    @Before
    public void setUp() {
        this.testingSchedulerOperation = new TestingSchedulerOperations();
        this.buildTopology();
    }

    private void buildTopology() {
        this.testingSchedulingTopology = new TestingSchedulingTopology();
        this.source = this.testingSchedulingTopology.addExecutionVertices().withParallelism(2).finish();
        this.map = this.testingSchedulingTopology.addExecutionVertices().withParallelism(2).finish();
        this.sink = this.testingSchedulingTopology.addExecutionVertices().withParallelism(2).finish();
        this.testingSchedulingTopology.connectPointwise(this.source, this.map).withResultPartitionState(ResultPartitionState.CREATED).withResultPartitionType(ResultPartitionType.BLOCKING).finish();
        this.testingSchedulingTopology.connectAllToAll(this.map, this.sink).withResultPartitionState(ResultPartitionState.CREATED).withResultPartitionType(ResultPartitionType.BLOCKING).finish();
    }

    @Test
    public void testStartScheduling() {
        this.startScheduling(this.testingSchedulingTopology);
        ArrayList<List<TestingSchedulingExecutionVertex>> expectedScheduledVertices = new ArrayList<List<TestingSchedulingExecutionVertex>>();
        expectedScheduledVertices.add(Arrays.asList(this.source.get(0)));
        expectedScheduledVertices.add(Arrays.asList(this.source.get(1)));
        StrategyTestUtil.assertLatestScheduledVerticesAreEqualTo(expectedScheduledVertices, this.testingSchedulerOperation);
    }

    @Test
    public void testRestartTasks() {
        VertexwiseSchedulingStrategy schedulingStrategy = this.startScheduling(this.testingSchedulingTopology);
        Set verticesToRestart = Stream.of(this.source, this.map, this.sink).flatMap(Collection::stream).map(TestingSchedulingExecutionVertex::getId).collect(Collectors.toSet());
        schedulingStrategy.restartTasks(verticesToRestart);
        ArrayList<List<TestingSchedulingExecutionVertex>> expectedScheduledVertices = new ArrayList<List<TestingSchedulingExecutionVertex>>();
        expectedScheduledVertices.add(Arrays.asList(this.source.get(0)));
        expectedScheduledVertices.add(Arrays.asList(this.source.get(1)));
        StrategyTestUtil.assertLatestScheduledVerticesAreEqualTo(expectedScheduledVertices, this.testingSchedulerOperation);
    }

    @Test
    public void testOnExecutionStateChangeToFinished() {
        VertexwiseSchedulingStrategy schedulingStrategy = this.startScheduling(this.testingSchedulingTopology);
        MatcherAssert.assertThat(this.testingSchedulerOperation.getScheduledVertices(), (Matcher)Matchers.hasSize((int)2));
        TestingSchedulingExecutionVertex source1 = this.source.get(0);
        source1.getProducedResults().iterator().next().setState(ResultPartitionState.CONSUMABLE);
        schedulingStrategy.onExecutionStateChange(source1.getId(), ExecutionState.FINISHED);
        MatcherAssert.assertThat(this.testingSchedulerOperation.getScheduledVertices(), (Matcher)Matchers.hasSize((int)3));
        TestingSchedulingExecutionVertex source2 = this.source.get(1);
        source2.getProducedResults().iterator().next().setState(ResultPartitionState.CONSUMABLE);
        schedulingStrategy.onExecutionStateChange(source2.getId(), ExecutionState.FINISHED);
        MatcherAssert.assertThat(this.testingSchedulerOperation.getScheduledVertices(), (Matcher)Matchers.hasSize((int)4));
        TestingSchedulingExecutionVertex map1 = this.map.get(0);
        map1.getProducedResults().iterator().next().setState(ResultPartitionState.CONSUMABLE);
        schedulingStrategy.onExecutionStateChange(map1.getId(), ExecutionState.FINISHED);
        MatcherAssert.assertThat(this.testingSchedulerOperation.getScheduledVertices(), (Matcher)Matchers.hasSize((int)4));
        TestingSchedulingExecutionVertex map2 = this.map.get(1);
        map2.getProducedResults().iterator().next().setState(ResultPartitionState.CONSUMABLE);
        schedulingStrategy.onExecutionStateChange(map2.getId(), ExecutionState.FINISHED);
        MatcherAssert.assertThat(this.testingSchedulerOperation.getScheduledVertices(), (Matcher)Matchers.hasSize((int)6));
        ArrayList<List<TestingSchedulingExecutionVertex>> expectedScheduledVertices = new ArrayList<List<TestingSchedulingExecutionVertex>>();
        expectedScheduledVertices.add(Arrays.asList(this.source.get(0)));
        expectedScheduledVertices.add(Arrays.asList(this.source.get(1)));
        expectedScheduledVertices.add(Arrays.asList(this.map.get(0)));
        expectedScheduledVertices.add(Arrays.asList(this.map.get(1)));
        expectedScheduledVertices.add(Arrays.asList(this.sink.get(0)));
        expectedScheduledVertices.add(Arrays.asList(this.sink.get(1)));
        StrategyTestUtil.assertLatestScheduledVerticesAreEqualTo(expectedScheduledVertices, this.testingSchedulerOperation);
    }

    @Test
    public void testUpdateStrategyWithAllToAll() {
        this.testUpdateStrategyOnTopologyUpdate(true);
    }

    @Test
    public void testUpdateStrategyWithPointWise() {
        this.testUpdateStrategyOnTopologyUpdate(false);
    }

    public void testUpdateStrategyOnTopologyUpdate(boolean allToAll) {
        TestingSchedulingTopology topology = new TestingSchedulingTopology();
        List<TestingSchedulingExecutionVertex> producers = topology.addExecutionVertices().withParallelism(2).finish();
        VertexwiseSchedulingStrategy schedulingStrategy = this.startScheduling(topology);
        List<TestingSchedulingExecutionVertex> consumers = topology.addExecutionVertices().withParallelism(2).finish();
        schedulingStrategy.onExecutionStateChange(producers.get(0).getId(), ExecutionState.FINISHED);
        if (allToAll) {
            topology.connectAllToAll(producers, consumers).withResultPartitionState(ResultPartitionState.CONSUMABLE).withResultPartitionType(ResultPartitionType.BLOCKING).finish();
        } else {
            topology.connectPointwise(producers, consumers).withResultPartitionState(ResultPartitionState.CONSUMABLE).withResultPartitionType(ResultPartitionType.BLOCKING).finish();
        }
        schedulingStrategy.notifySchedulingTopologyUpdated((SchedulingTopology)topology, consumers.stream().map(TestingSchedulingExecutionVertex::getId).collect(Collectors.toList()));
        schedulingStrategy.onExecutionStateChange(producers.get(1).getId(), ExecutionState.FINISHED);
        StrategyTestUtil.assertLatestScheduledVerticesAreEqualTo(Arrays.asList(Arrays.asList(producers.get(0)), Arrays.asList(producers.get(1)), Arrays.asList(consumers.get(0)), Arrays.asList(consumers.get(1))), this.testingSchedulerOperation);
    }

    VertexwiseSchedulingStrategy startScheduling(SchedulingTopology schedulingTopology) {
        VertexwiseSchedulingStrategy schedulingStrategy = new VertexwiseSchedulingStrategy((SchedulerOperations)this.testingSchedulerOperation, schedulingTopology);
        schedulingStrategy.startScheduling();
        return schedulingStrategy;
    }
}

