/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.runtime.state.CompositeKeySerializationUtils;
import org.apache.flink.runtime.state.KeyGroupRangeAssignment;
import org.apache.flink.runtime.state.SerializedCompositeKeyBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SerializedCompositeKeyBuilderTest {
    private final DataOutputSerializer dataOutputSerializer = new DataOutputSerializer(128);
    private static final int[] TEST_PARALLELISMS = new int[]{64, 4096};
    private static final Collection<Integer> TEST_INTS = Arrays.asList(42, 4711);
    private static final Collection<String> TEST_STRINGS = Arrays.asList("test123", "abc");

    @Before
    public void before() {
        this.dataOutputSerializer.clear();
    }

    @Test
    public void testSetKey() throws IOException {
        for (int parallelism : TEST_PARALLELISMS) {
            this.testSetKeyInternal((TypeSerializer)IntSerializer.INSTANCE, (Collection)TEST_INTS, parallelism);
            this.testSetKeyInternal((TypeSerializer)StringSerializer.INSTANCE, (Collection)TEST_STRINGS, parallelism);
        }
    }

    @Test
    public void testSetKeyNamespace() throws IOException {
        this.testSetKeyNamespaceInternal(BuildKeyAndNamespaceType.BUILD);
    }

    @Test
    public void testSetKeyNamespaceWithSet() throws IOException {
        this.testSetKeyNamespaceInternal(BuildKeyAndNamespaceType.SET_AND_BUILD);
    }

    private void testSetKeyNamespaceInternal(BuildKeyAndNamespaceType buildKeyAndNamespaceType) throws IOException {
        for (int parallelism : TEST_PARALLELISMS) {
            this.testSetKeyNamespaceInternal((TypeSerializer)IntSerializer.INSTANCE, (TypeSerializer)IntSerializer.INSTANCE, (Collection)TEST_INTS, (Collection)TEST_INTS, parallelism, buildKeyAndNamespaceType);
            this.testSetKeyNamespaceInternal((TypeSerializer)IntSerializer.INSTANCE, (TypeSerializer)StringSerializer.INSTANCE, (Collection)TEST_INTS, (Collection)TEST_STRINGS, parallelism, buildKeyAndNamespaceType);
            this.testSetKeyNamespaceInternal((TypeSerializer)StringSerializer.INSTANCE, (TypeSerializer)IntSerializer.INSTANCE, (Collection)TEST_STRINGS, (Collection)TEST_INTS, parallelism, buildKeyAndNamespaceType);
            this.testSetKeyNamespaceInternal((TypeSerializer)StringSerializer.INSTANCE, (TypeSerializer)StringSerializer.INSTANCE, (Collection)TEST_STRINGS, (Collection)TEST_STRINGS, parallelism, buildKeyAndNamespaceType);
        }
    }

    @Test
    public void testSetKeyNamespaceUserKey() throws IOException {
        this.testSetKeyNamespaceUserKeyInternal(BuildKeyAndNamespaceType.BUILD);
    }

    @Test
    public void testSetKeyNamespaceUserKeyWithSet() throws IOException {
        this.testSetKeyNamespaceUserKeyInternal(BuildKeyAndNamespaceType.SET_AND_BUILD);
    }

    private void testSetKeyNamespaceUserKeyInternal(BuildKeyAndNamespaceType buildKeyAndNamespaceType) throws IOException {
        for (int parallelism : TEST_PARALLELISMS) {
            this.testSetKeyNamespaceUserKeyInternal((TypeSerializer)IntSerializer.INSTANCE, (TypeSerializer)IntSerializer.INSTANCE, (TypeSerializer)IntSerializer.INSTANCE, (Collection)TEST_INTS, (Collection)TEST_INTS, (Collection)TEST_INTS, parallelism, buildKeyAndNamespaceType);
            this.testSetKeyNamespaceUserKeyInternal((TypeSerializer)IntSerializer.INSTANCE, (TypeSerializer)StringSerializer.INSTANCE, (TypeSerializer)IntSerializer.INSTANCE, (Collection)TEST_INTS, (Collection)TEST_STRINGS, (Collection)TEST_INTS, parallelism, buildKeyAndNamespaceType);
            this.testSetKeyNamespaceUserKeyInternal((TypeSerializer)StringSerializer.INSTANCE, (TypeSerializer)IntSerializer.INSTANCE, (TypeSerializer)IntSerializer.INSTANCE, (Collection)TEST_STRINGS, (Collection)TEST_INTS, (Collection)TEST_INTS, parallelism, buildKeyAndNamespaceType);
            this.testSetKeyNamespaceUserKeyInternal((TypeSerializer)StringSerializer.INSTANCE, (TypeSerializer)StringSerializer.INSTANCE, (TypeSerializer)IntSerializer.INSTANCE, (Collection)TEST_STRINGS, (Collection)TEST_STRINGS, (Collection)TEST_INTS, parallelism, buildKeyAndNamespaceType);
            this.testSetKeyNamespaceUserKeyInternal((TypeSerializer)IntSerializer.INSTANCE, (TypeSerializer)IntSerializer.INSTANCE, (TypeSerializer)StringSerializer.INSTANCE, (Collection)TEST_INTS, (Collection)TEST_INTS, (Collection)TEST_STRINGS, parallelism, buildKeyAndNamespaceType);
            this.testSetKeyNamespaceUserKeyInternal((TypeSerializer)IntSerializer.INSTANCE, (TypeSerializer)StringSerializer.INSTANCE, (TypeSerializer)StringSerializer.INSTANCE, (Collection)TEST_INTS, (Collection)TEST_STRINGS, (Collection)TEST_STRINGS, parallelism, buildKeyAndNamespaceType);
            this.testSetKeyNamespaceUserKeyInternal((TypeSerializer)StringSerializer.INSTANCE, (TypeSerializer)IntSerializer.INSTANCE, (TypeSerializer)StringSerializer.INSTANCE, (Collection)TEST_STRINGS, (Collection)TEST_INTS, (Collection)TEST_STRINGS, parallelism, buildKeyAndNamespaceType);
            this.testSetKeyNamespaceUserKeyInternal((TypeSerializer)StringSerializer.INSTANCE, (TypeSerializer)StringSerializer.INSTANCE, (TypeSerializer)StringSerializer.INSTANCE, (Collection)TEST_STRINGS, (Collection)TEST_STRINGS, (Collection)TEST_STRINGS, parallelism, buildKeyAndNamespaceType);
        }
    }

    private <K> void testSetKeyInternal(TypeSerializer<K> serializer, Collection<K> testKeys, int maxParallelism) throws IOException {
        int prefixBytes = maxParallelism > 127 ? 2 : 1;
        SerializedCompositeKeyBuilder<K> keyBuilder = this.createRocksDBSerializedCompositeKeyBuilder(serializer, prefixBytes);
        DataInputDeserializer deserializer = new DataInputDeserializer();
        for (K testKey : testKeys) {
            int keyGroup = this.setKeyAndReturnKeyGroup(keyBuilder, testKey, maxParallelism);
            byte[] result = this.dataOutputSerializer.getCopyOfBuffer();
            deserializer.setBuffer(result);
            this.assertKeyKeyGroupBytes(testKey, keyGroup, prefixBytes, serializer, deserializer, false);
            Assert.assertEquals((long)0L, (long)deserializer.available());
        }
    }

    private <K, N> void testSetKeyNamespaceInternal(TypeSerializer<K> keySerializer, TypeSerializer<N> namespaceSerializer, Collection<K> testKeys, Collection<N> testNamespaces, int maxParallelism, BuildKeyAndNamespaceType buildKeyAndNamespaceType) throws IOException {
        int prefixBytes = maxParallelism > 127 ? 2 : 1;
        SerializedCompositeKeyBuilder<K> keyBuilder = this.createRocksDBSerializedCompositeKeyBuilder(keySerializer, prefixBytes);
        DataInputDeserializer deserializer = new DataInputDeserializer();
        boolean ambiguousPossible = keyBuilder.isAmbiguousCompositeKeyPossible(namespaceSerializer);
        for (K testKey : testKeys) {
            int keyGroup = this.setKeyAndReturnKeyGroup(keyBuilder, testKey, maxParallelism);
            for (N testNamespace : testNamespaces) {
                byte[] compositeBytes;
                if (buildKeyAndNamespaceType == BuildKeyAndNamespaceType.BUILD) {
                    compositeBytes = keyBuilder.buildCompositeKeyNamespace(testNamespace, namespaceSerializer);
                } else {
                    keyBuilder.setNamespace(testNamespace, namespaceSerializer);
                    compositeBytes = keyBuilder.build();
                }
                deserializer.setBuffer(compositeBytes);
                this.assertKeyGroupKeyNamespaceBytes(testKey, keyGroup, prefixBytes, keySerializer, testNamespace, namespaceSerializer, deserializer, ambiguousPossible);
                Assert.assertEquals((long)0L, (long)deserializer.available());
            }
        }
    }

    private <K, N, U> void testSetKeyNamespaceUserKeyInternal(TypeSerializer<K> keySerializer, TypeSerializer<N> namespaceSerializer, TypeSerializer<U> userKeySerializer, Collection<K> testKeys, Collection<N> testNamespaces, Collection<U> testUserKeys, int maxParallelism, BuildKeyAndNamespaceType buildKeyAndNamespaceType) throws IOException {
        int prefixBytes = maxParallelism > 127 ? 2 : 1;
        SerializedCompositeKeyBuilder<K> keyBuilder = this.createRocksDBSerializedCompositeKeyBuilder(keySerializer, prefixBytes);
        DataInputDeserializer deserializer = new DataInputDeserializer();
        boolean ambiguousPossible = keyBuilder.isAmbiguousCompositeKeyPossible(namespaceSerializer);
        for (K testKey : testKeys) {
            int keyGroup = this.setKeyAndReturnKeyGroup(keyBuilder, testKey, maxParallelism);
            for (N testNamespace : testNamespaces) {
                if (buildKeyAndNamespaceType == BuildKeyAndNamespaceType.SET_AND_BUILD) {
                    keyBuilder.setNamespace(testNamespace, namespaceSerializer);
                }
                for (U testUserKey : testUserKeys) {
                    byte[] compositeBytes = buildKeyAndNamespaceType == BuildKeyAndNamespaceType.BUILD ? keyBuilder.buildCompositeKeyNamesSpaceUserKey(testNamespace, namespaceSerializer, testUserKey, userKeySerializer) : keyBuilder.buildCompositeKeyUserKey(testUserKey, userKeySerializer);
                    deserializer.setBuffer(compositeBytes);
                    this.assertKeyGroupKeyNamespaceUserKeyBytes(testKey, keyGroup, prefixBytes, keySerializer, testNamespace, namespaceSerializer, testUserKey, userKeySerializer, deserializer, ambiguousPossible);
                    Assert.assertEquals((long)0L, (long)deserializer.available());
                }
            }
        }
    }

    private <K> SerializedCompositeKeyBuilder<K> createRocksDBSerializedCompositeKeyBuilder(TypeSerializer<K> serializer, int prefixBytes) {
        boolean variableSize = CompositeKeySerializationUtils.isSerializerTypeVariableSized(serializer);
        return new SerializedCompositeKeyBuilder(serializer, this.dataOutputSerializer, prefixBytes, variableSize, 0);
    }

    private <K> int setKeyAndReturnKeyGroup(SerializedCompositeKeyBuilder<K> compositeKeyBuilder, K key, int maxParallelism) {
        int keyGroup = KeyGroupRangeAssignment.assignKeyToParallelOperator(key, (int)maxParallelism, (int)maxParallelism);
        compositeKeyBuilder.setKeyAndKeyGroup(key, keyGroup);
        return keyGroup;
    }

    private <K> void assertKeyKeyGroupBytes(K key, int keyGroup, int prefixBytes, TypeSerializer<K> typeSerializer, DataInputDeserializer deserializer, boolean ambiguousCompositeKeyPossible) throws IOException {
        Assert.assertEquals((long)keyGroup, (long)CompositeKeySerializationUtils.readKeyGroup((int)prefixBytes, (DataInputView)deserializer));
        Assert.assertEquals(key, (Object)CompositeKeySerializationUtils.readKey(typeSerializer, (DataInputDeserializer)deserializer, (boolean)ambiguousCompositeKeyPossible));
    }

    private <K, N> void assertKeyGroupKeyNamespaceBytes(K key, int keyGroup, int prefixBytes, TypeSerializer<K> keySerializer, N namespace, TypeSerializer<N> namespaceSerializer, DataInputDeserializer deserializer, boolean ambiguousCompositeKeyPossible) throws IOException {
        this.assertKeyKeyGroupBytes(key, keyGroup, prefixBytes, keySerializer, deserializer, ambiguousCompositeKeyPossible);
        Object readNamespace = CompositeKeySerializationUtils.readNamespace(namespaceSerializer, (DataInputDeserializer)deserializer, (boolean)ambiguousCompositeKeyPossible);
        Assert.assertEquals(namespace, (Object)readNamespace);
    }

    private <K, N, U> void assertKeyGroupKeyNamespaceUserKeyBytes(K key, int keyGroup, int prefixBytes, TypeSerializer<K> keySerializer, N namespace, TypeSerializer<N> namespaceSerializer, U userKey, TypeSerializer<U> userKeySerializer, DataInputDeserializer deserializer, boolean ambiguousCompositeKeyPossible) throws IOException {
        this.assertKeyGroupKeyNamespaceBytes(key, keyGroup, prefixBytes, keySerializer, namespace, namespaceSerializer, deserializer, ambiguousCompositeKeyPossible);
        Assert.assertEquals(userKey, (Object)userKeySerializer.deserialize((DataInputView)deserializer));
    }

    static enum BuildKeyAndNamespaceType {
        BUILD,
        SET_AND_BUILD;

    }
}

