/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.groups;

import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MetricOptions;
import org.apache.flink.metrics.CharacterFilter;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.MetricRegistryImpl;
import org.apache.flink.runtime.metrics.MetricRegistryTestUtils;
import org.apache.flink.runtime.metrics.dump.QueryScopeInfo;
import org.apache.flink.runtime.metrics.groups.JobManagerJobMetricGroup;
import org.apache.flink.runtime.metrics.groups.JobManagerMetricGroup;
import org.apache.flink.runtime.metrics.util.DummyCharacterFilter;
import org.apache.flink.util.TestLogger;
import org.apache.flink.util.concurrent.Executors;
import org.junit.Assert;
import org.junit.Test;

public class JobManagerGroupTest
extends TestLogger {
    @Test
    public void addAndRemoveJobs() throws Exception {
        MetricRegistryImpl registry = new MetricRegistryImpl(MetricRegistryTestUtils.defaultMetricRegistryConfiguration());
        JobManagerMetricGroup group = JobManagerMetricGroup.createJobManagerMetricGroup((MetricRegistry)registry, (String)"localhost");
        JobID jid1 = new JobID();
        JobID jid2 = new JobID();
        String jobName1 = "testjob";
        String jobName2 = "anotherJob";
        JobManagerJobMetricGroup jmJobGroup11 = group.addJob(jid1, "testjob");
        JobManagerJobMetricGroup jmJobGroup12 = group.addJob(jid1, "testjob");
        JobManagerJobMetricGroup jmJobGroup21 = group.addJob(jid2, "anotherJob");
        Assert.assertEquals((Object)jmJobGroup11, (Object)jmJobGroup12);
        Assert.assertEquals((long)2L, (long)group.numRegisteredJobMetricGroups());
        group.localCleanupAsync(jid1, Executors.directExecutor()).join();
        Assert.assertTrue((boolean)jmJobGroup11.isClosed());
        Assert.assertEquals((long)1L, (long)group.numRegisteredJobMetricGroups());
        group.localCleanupAsync(jid2, Executors.directExecutor()).join();
        Assert.assertTrue((boolean)jmJobGroup21.isClosed());
        Assert.assertEquals((long)0L, (long)group.numRegisteredJobMetricGroups());
        registry.closeAsync().get();
    }

    @Test
    public void testCloseClosesAll() throws Exception {
        MetricRegistryImpl registry = new MetricRegistryImpl(MetricRegistryTestUtils.defaultMetricRegistryConfiguration());
        JobManagerMetricGroup group = JobManagerMetricGroup.createJobManagerMetricGroup((MetricRegistry)registry, (String)"localhost");
        JobID jid1 = new JobID();
        JobID jid2 = new JobID();
        String jobName1 = "testjob";
        String jobName2 = "anotherJob";
        JobManagerJobMetricGroup jmJobGroup11 = group.addJob(jid1, "testjob");
        JobManagerJobMetricGroup jmJobGroup21 = group.addJob(jid2, "anotherJob");
        group.close();
        Assert.assertTrue((boolean)jmJobGroup11.isClosed());
        Assert.assertTrue((boolean)jmJobGroup21.isClosed());
        registry.closeAsync().get();
    }

    @Test
    public void testGenerateScopeDefault() throws Exception {
        MetricRegistryImpl registry = new MetricRegistryImpl(MetricRegistryTestUtils.defaultMetricRegistryConfiguration());
        JobManagerMetricGroup group = JobManagerMetricGroup.createJobManagerMetricGroup((MetricRegistry)registry, (String)"localhost");
        Assert.assertArrayEquals((Object[])new String[]{"localhost", "jobmanager"}, (Object[])group.getScopeComponents());
        Assert.assertEquals((Object)"localhost.jobmanager.name", (Object)group.getMetricIdentifier("name"));
        registry.closeAsync().get();
    }

    @Test
    public void testGenerateScopeCustom() throws Exception {
        Configuration cfg = new Configuration();
        cfg.setString(MetricOptions.SCOPE_NAMING_JM, "constant.<host>.foo.<host>");
        MetricRegistryImpl registry = new MetricRegistryImpl(MetricRegistryTestUtils.fromConfiguration(cfg));
        JobManagerMetricGroup group = JobManagerMetricGroup.createJobManagerMetricGroup((MetricRegistry)registry, (String)"host");
        Assert.assertArrayEquals((Object[])new String[]{"constant", "host", "foo", "host"}, (Object[])group.getScopeComponents());
        Assert.assertEquals((Object)"constant.host.foo.host.name", (Object)group.getMetricIdentifier("name"));
        registry.closeAsync().get();
    }

    @Test
    public void testCreateQueryServiceMetricInfo() {
        MetricRegistryImpl registry = new MetricRegistryImpl(MetricRegistryTestUtils.defaultMetricRegistryConfiguration());
        JobManagerMetricGroup jm = JobManagerMetricGroup.createJobManagerMetricGroup((MetricRegistry)registry, (String)"host");
        QueryScopeInfo.JobManagerQueryScopeInfo info = jm.createQueryServiceMetricInfo((CharacterFilter)new DummyCharacterFilter());
        Assert.assertEquals((Object)"", (Object)info.scope);
    }
}

