/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.testutils.types;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.operators.testutils.types.StringPair;
import org.apache.flink.types.StringValue;

public class StringPairSerializer
extends TypeSerializer<StringPair> {
    private static final long serialVersionUID = 1L;

    public boolean isImmutableType() {
        return false;
    }

    public StringPairSerializer duplicate() {
        return this;
    }

    public StringPair createInstance() {
        return new StringPair();
    }

    public StringPair copy(StringPair from) {
        return new StringPair(from.getKey(), from.getValue());
    }

    public StringPair copy(StringPair from, StringPair reuse) {
        reuse.setKey(from.getKey());
        reuse.setValue(from.getValue());
        return reuse;
    }

    public int getLength() {
        return -1;
    }

    public void serialize(StringPair record, DataOutputView target) throws IOException {
        StringValue.writeString((CharSequence)record.getKey(), (DataOutput)target);
        StringValue.writeString((CharSequence)record.getValue(), (DataOutput)target);
    }

    public StringPair deserialize(DataInputView source) throws IOException {
        return new StringPair(StringValue.readString((DataInput)source), StringValue.readString((DataInput)source));
    }

    public StringPair deserialize(StringPair record, DataInputView source) throws IOException {
        record.setKey(StringValue.readString((DataInput)source));
        record.setValue(StringValue.readString((DataInput)source));
        return record;
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        StringValue.writeString((CharSequence)StringValue.readString((DataInput)source), (DataOutput)target);
        StringValue.writeString((CharSequence)StringValue.readString((DataInput)source), (DataOutput)target);
    }

    public boolean equals(Object obj) {
        return obj instanceof StringPairSerializer;
    }

    public int hashCode() {
        return StringPairSerializer.class.hashCode();
    }

    public TypeSerializerSnapshot<StringPair> snapshotConfiguration() {
        throw new UnsupportedOperationException();
    }
}

