/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.throughput;

import org.apache.flink.runtime.throughput.BufferSizeEMA;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class BufferSizeEMATest
extends TestLogger {
    @Test
    public void testCalculationBufferSize() {
        BufferSizeEMA calculator = new BufferSizeEMA(200, 10, 3L);
        MatcherAssert.assertThat((Object)calculator.calculateBufferSize(111L, 13), (Matcher)Matchers.is((Object)104));
        MatcherAssert.assertThat((Object)calculator.calculateBufferSize(107L, 7), (Matcher)Matchers.is((Object)59));
        MatcherAssert.assertThat((Object)calculator.calculateBufferSize(107L, 7), (Matcher)Matchers.is((Object)37));
        MatcherAssert.assertThat((Object)calculator.calculateBufferSize(107L, 7), (Matcher)Matchers.is((Object)26));
        MatcherAssert.assertThat((Object)calculator.calculateBufferSize(107L, 7), (Matcher)Matchers.is((Object)20));
        MatcherAssert.assertThat((Object)calculator.calculateBufferSize(107L, 7), (Matcher)Matchers.is((Object)17));
        MatcherAssert.assertThat((Object)calculator.calculateBufferSize(107L, 13), (Matcher)Matchers.is((Object)12));
        MatcherAssert.assertThat((Object)calculator.calculateBufferSize(107L, 13), (Matcher)Matchers.is((Object)10));
        MatcherAssert.assertThat((Object)calculator.calculateBufferSize(333L, 1), (Matcher)Matchers.is((Object)15));
        MatcherAssert.assertThat((Object)calculator.calculateBufferSize(333L, 1), (Matcher)Matchers.is((Object)22));
        MatcherAssert.assertThat((Object)calculator.calculateBufferSize(333L, 1), (Matcher)Matchers.is((Object)33));
        MatcherAssert.assertThat((Object)calculator.calculateBufferSize(333L, 1), (Matcher)Matchers.is((Object)49));
        MatcherAssert.assertThat((Object)calculator.calculateBufferSize(333L, 1), (Matcher)Matchers.is((Object)73));
        MatcherAssert.assertThat((Object)calculator.calculateBufferSize(333L, 1), (Matcher)Matchers.is((Object)109));
    }

    @Test
    public void testSizeGreaterThanMaxSize() {
        BufferSizeEMA calculator = new BufferSizeEMA(200, 10, 3L);
        MatcherAssert.assertThat((Object)calculator.calculateBufferSize(0L, 1), (Matcher)Matchers.is((Object)100));
        MatcherAssert.assertThat((Object)calculator.calculateBufferSize(1000L, 1), (Matcher)Matchers.is((Object)150));
        MatcherAssert.assertThat((Object)calculator.calculateBufferSize(1000L, 1), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)calculator.calculateBufferSize(1000L, 1), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void testSizeLessThanMinSize() {
        BufferSizeEMA calculator = new BufferSizeEMA(200, 10, 3L);
        MatcherAssert.assertThat((Object)calculator.calculateBufferSize(0L, 1), (Matcher)Matchers.is((Object)100));
        MatcherAssert.assertThat((Object)calculator.calculateBufferSize(0L, 1), (Matcher)Matchers.is((Object)50));
        MatcherAssert.assertThat((Object)calculator.calculateBufferSize(0L, 1), (Matcher)Matchers.is((Object)25));
        MatcherAssert.assertThat((Object)calculator.calculateBufferSize(0L, 1), (Matcher)Matchers.is((Object)12));
        MatcherAssert.assertThat((Object)calculator.calculateBufferSize(0L, 1), (Matcher)Matchers.is((Object)10));
        MatcherAssert.assertThat((Object)calculator.calculateBufferSize(0L, 1), (Matcher)Matchers.is((Object)10));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNegativeTotalSize() {
        BufferSizeEMA calculator = new BufferSizeEMA(100, 200, 2L);
        calculator.calculateBufferSize(-1L, 1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testZeroBuffers() {
        BufferSizeEMA calculator = new BufferSizeEMA(100, 200, 2L);
        calculator.calculateBufferSize(1L, 0);
    }
}

