/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.BlobServerOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.local.LocalFileSystem;
import org.apache.flink.runtime.blob.BlobKey;
import org.apache.flink.runtime.blob.BlobStore;
import org.apache.flink.runtime.blob.BlobUtils;
import org.apache.flink.runtime.blob.FileSystemBlobStore;
import org.apache.flink.runtime.blob.PermanentBlobKey;
import org.apache.flink.runtime.blob.TestingBlobUtils;
import org.apache.flink.runtime.blob.TransientBlobKey;
import org.apache.flink.util.FileUtils;
import org.apache.flink.util.Reference;
import org.apache.flink.util.TestLogger;
import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.slf4j.Logger;

public class BlobUtilsTest
extends TestLogger {
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void testDefaultBlobStorageDirectory() throws IOException {
        Configuration config = new Configuration();
        String blobStorageDir = this.temporaryFolder.newFolder().getAbsolutePath();
        config.setString(BlobServerOptions.STORAGE_DIRECTORY, blobStorageDir);
        config.setString(CoreOptions.TMP_DIRS, this.temporaryFolder.newFolder().getAbsolutePath());
        File dir = (File)BlobUtils.createBlobStorageDirectory((Configuration)config, null).deref();
        Assertions.assertThat((String)dir.getAbsolutePath()).startsWith((CharSequence)blobStorageDir);
    }

    @Test
    public void testTaskManagerFallbackBlobStorageDirectory1() throws IOException {
        Configuration config = new Configuration();
        File fallbackDirectory = new File(this.temporaryFolder.newFolder(), "foobar");
        File dir = (File)BlobUtils.createBlobStorageDirectory((Configuration)config, (Reference)Reference.borrowed((Object)fallbackDirectory)).deref();
        Assertions.assertThat((File)dir).isEqualTo((Object)fallbackDirectory);
    }

    @Test(expected=IOException.class)
    public void testBlobUtilsFailIfNoStorageDirectoryIsSpecified() throws IOException {
        BlobUtils.createBlobStorageDirectory((Configuration)new Configuration(), null);
    }

    @Test
    public void testCheckAndDeleteCorruptedBlobsDeletesCorruptedBlobs() throws IOException {
        File storageDir = this.temporaryFolder.newFolder();
        JobID jobId = new JobID();
        byte[] validContent = "valid".getBytes(StandardCharsets.UTF_8);
        PermanentBlobKey validPermanentBlobKey = TestingBlobUtils.writePermanentBlob(storageDir.toPath(), jobId, validContent);
        TransientBlobKey validTransientBlobKey = TestingBlobUtils.writeTransientBlob(storageDir.toPath(), jobId, validContent);
        PermanentBlobKey corruptedBlobKey = TestingBlobUtils.writePermanentBlob(storageDir.toPath(), jobId, validContent);
        FileUtils.writeFileUtf8((File)new File(BlobUtils.getStorageLocationPath((String)storageDir.getAbsolutePath(), (JobID)jobId, (BlobKey)corruptedBlobKey)), (String)"corrupted");
        BlobUtils.checkAndDeleteCorruptedBlobs((Path)storageDir.toPath(), (Logger)this.log);
        List blobKeys = BlobUtils.listBlobsInDirectory((Path)storageDir.toPath()).stream().map(BlobUtils.Blob::getBlobKey).collect(Collectors.toList());
        Assertions.assertThat(blobKeys).containsExactlyInAnyOrder((Object[])new BlobKey[]{validPermanentBlobKey, validTransientBlobKey});
    }

    @Test
    public void testMoveTempFileToStoreSucceeds() throws IOException {
        FileSystemBlobStore blobStore = new FileSystemBlobStore((FileSystem)new LocalFileSystem(), this.temporaryFolder.newFolder().toString());
        JobID jobId = new JobID();
        File storageFile = new File(this.temporaryFolder.getRoot(), UUID.randomUUID().toString());
        File incomingFile = this.temporaryFolder.newFile();
        byte[] fileContent = new byte[]{1, 2, 3, 4};
        BlobKey blobKey = BlobKey.createKey((BlobKey.BlobType)BlobKey.BlobType.PERMANENT_BLOB, (byte[])BlobUtils.createMessageDigest().digest(fileContent));
        Files.write(incomingFile.toPath(), fileContent, new OpenOption[0]);
        BlobUtils.moveTempFileToStore((File)incomingFile, (JobID)jobId, (BlobKey)blobKey, (File)storageFile, (Logger)this.log, (BlobStore)blobStore);
        Assertions.assertThat((File)incomingFile).doesNotExist();
        Assertions.assertThat((File)storageFile).hasBinaryContent(fileContent);
        File blobStoreFile = new File(this.temporaryFolder.getRoot(), UUID.randomUUID().toString());
        Assertions.assertThat((boolean)blobStore.get(jobId, blobKey, blobStoreFile)).isTrue();
        Assertions.assertThat((File)blobStoreFile).hasBinaryContent(fileContent);
    }

    @Test
    public void testCleanupIfMoveTempFileToStoreFails() throws IOException {
        File storageFile = new File(this.temporaryFolder.getRoot(), UUID.randomUUID().toString());
        File incomingFile = this.temporaryFolder.newFile();
        Files.write(incomingFile.toPath(), new byte[]{1, 2, 3, 4}, new OpenOption[0]);
        FileSystemBlobStore blobStore = new FileSystemBlobStore((FileSystem)new LocalFileSystem(), this.temporaryFolder.newFolder().getAbsolutePath());
        JobID jobId = new JobID();
        BlobKey blobKey = BlobKey.createKey((BlobKey.BlobType)BlobKey.BlobType.PERMANENT_BLOB);
        Assertions.assertThatThrownBy(() -> BlobUtils.internalMoveTempFileToStore((File)incomingFile, (JobID)jobId, (BlobKey)blobKey, (File)storageFile, (Logger)this.log, (BlobStore)blobStore, (source, target) -> {
            throw new IOException("Test Failure");
        })).isInstanceOf(IOException.class);
        Assertions.assertThatThrownBy(() -> blobStore.get(jobId, blobKey, new File(this.temporaryFolder.getRoot(), UUID.randomUUID().toString()))).isInstanceOf(FileNotFoundException.class);
        Assertions.assertThat((File)incomingFile).doesNotExist();
        Assertions.assertThat((File)storageFile).doesNotExist();
    }
}

