/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.netty;

import java.util.Optional;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferBuilderTestUtils;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.netty.NettyPayload;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class NettyPayloadTest {
    NettyPayloadTest() {
    }

    @Test
    void testGetBuffer() {
        Buffer buffer = BufferBuilderTestUtils.buildSomeBuffer(0);
        NettyPayload nettyPayload = NettyPayload.newBuffer((Buffer)buffer, (int)0, (int)0);
        Assertions.assertThat((Optional)nettyPayload.getBuffer()).isPresent();
        Assertions.assertThat((Optional)nettyPayload.getBuffer()).hasValue((Object)buffer);
        Assertions.assertThatThrownBy(() -> NettyPayload.newBuffer(null, (int)0, (int)0)).isInstanceOf(IllegalStateException.class);
        Assertions.assertThatThrownBy(() -> NettyPayload.newBuffer((Buffer)buffer, (int)-1, (int)0)).isInstanceOf(IllegalStateException.class);
        Assertions.assertThatThrownBy(() -> NettyPayload.newBuffer((Buffer)buffer, (int)0, (int)-1)).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void testGetError() {
        RuntimeException error = new RuntimeException("test exception");
        NettyPayload nettyPayload = NettyPayload.newError((Throwable)error);
        Assertions.assertThat((Optional)nettyPayload.getError()).isPresent();
        Assertions.assertThat((Optional)nettyPayload.getError()).hasValue((Object)error);
        Assertions.assertThatThrownBy(() -> NettyPayload.newError(null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void testGetBufferIndex() {
        Buffer buffer = BufferBuilderTestUtils.buildSomeBuffer(0);
        int bufferIndex = 0;
        int subpartitionId = 1;
        NettyPayload nettyPayload = NettyPayload.newBuffer((Buffer)buffer, (int)bufferIndex, (int)subpartitionId);
        Assertions.assertThat((int)nettyPayload.getBufferIndex()).isEqualTo(bufferIndex);
    }

    @Test
    void testGetSubpartitionId() {
        Buffer buffer = BufferBuilderTestUtils.buildSomeBuffer(0);
        int bufferIndex = 0;
        int subpartitionId = 1;
        NettyPayload nettyPayload = NettyPayload.newBuffer((Buffer)buffer, (int)bufferIndex, (int)subpartitionId);
        Assertions.assertThat((int)nettyPayload.getSubpartitionId()).isEqualTo(subpartitionId);
    }

    @Test
    void testGetSegmentId() {
        int segmentId = 1;
        NettyPayload nettyPayload = NettyPayload.newSegment((int)segmentId);
        Assertions.assertThat((int)nettyPayload.getSegmentId()).isEqualTo(segmentId);
        Assertions.assertThatThrownBy(() -> NettyPayload.newSegment((int)-1)).isInstanceOf(IllegalStateException.class);
    }
}

