/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.netty;

import java.util.Optional;
import java.util.function.Function;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.netty.NettyConnectionReader;

public class TestingNettyConnectionReader
implements NettyConnectionReader {
    private final Function<Integer, Buffer> readBufferFunction;

    private TestingNettyConnectionReader(Function<Integer, Buffer> readBufferFunction) {
        this.readBufferFunction = readBufferFunction;
    }

    public Optional<Buffer> readBuffer(int segmentId) {
        return Optional.of(this.readBufferFunction.apply(segmentId));
    }

    public static class Builder {
        private Function<Integer, Buffer> readBufferFunction = segmentId -> null;

        public Builder setReadBufferFunction(Function<Integer, Buffer> readBufferFunction) {
            this.readBufferFunction = readBufferFunction;
            return this;
        }

        public TestingNettyConnectionReader build() {
            return new TestingNettyConnectionReader(this.readBufferFunction);
        }
    }
}

