/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.netty;

import java.io.IOException;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStoragePartitionId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageSubpartitionId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.AvailabilityNotifier;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierConsumerAgent;

public class TestingTierConsumerAgent
implements TierConsumerAgent {
    private final Runnable startNotifier;
    private final Supplier<Buffer> bufferSupplier;
    private final Runnable availabilityNotifierRegistrationRunnable;
    private final Runnable closeNotifier;

    private TestingTierConsumerAgent(Runnable startNotifier, Supplier<Buffer> bufferSupplier, Runnable availabilityNotifierRegistrationRunnable, Runnable closeNotifier) {
        this.startNotifier = startNotifier;
        this.bufferSupplier = bufferSupplier;
        this.availabilityNotifierRegistrationRunnable = availabilityNotifierRegistrationRunnable;
        this.closeNotifier = closeNotifier;
    }

    public void start() {
        this.startNotifier.run();
    }

    public Optional<Buffer> getNextBuffer(TieredStoragePartitionId partitionId, TieredStorageSubpartitionId subpartitionId, int segmentId) {
        Buffer buffer = this.bufferSupplier.get();
        return buffer == null ? Optional.empty() : Optional.of(buffer);
    }

    public void registerAvailabilityNotifier(AvailabilityNotifier notifier) {
        this.availabilityNotifierRegistrationRunnable.run();
    }

    public void close() throws IOException {
        this.closeNotifier.run();
    }

    public static class Builder {
        private Runnable startNotifier = () -> {};
        private Supplier<Buffer> bufferSupplier = () -> null;
        private Runnable availabilityNotifierRegistrationRunnable = () -> {};
        private Runnable closeNotifier = () -> {};

        public Builder setStartNotifier(Runnable startNotifier) {
            this.startNotifier = startNotifier;
            return this;
        }

        public Builder setBufferSupplier(Supplier<Buffer> bufferSupplier) {
            this.bufferSupplier = bufferSupplier;
            return this;
        }

        public Builder setAvailabilityNotifierRegistrationRunnable(Runnable availabilityNotifierRegistrationRunnable) {
            this.availabilityNotifierRegistrationRunnable = availabilityNotifierRegistrationRunnable;
            return this;
        }

        public Builder setCloseNotifier(Runnable closeNotifier) {
            this.closeNotifier = closeNotifier;
            return this;
        }

        public TestingTierConsumerAgent build() {
            return new TestingTierConsumerAgent(this.startNotifier, this.bufferSupplier, this.availabilityNotifierRegistrationRunnable, this.closeNotifier);
        }
    }
}

