/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.remote;

import java.io.File;
import java.util.Collections;
import java.util.Optional;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.io.network.buffer.BufferBuilderTestUtils;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStoragePartitionId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageSubpartitionId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.file.PartitionFileReader;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.file.TestingPartitionFileReader;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.remote.RemoteStorageScanner;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.remote.RemoteTierConsumerAgent;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class RemoteTierConsumerAgentTest {
    @TempDir
    private File tempFolder;
    private String remoteStoragePath;

    RemoteTierConsumerAgentTest() {
    }

    @BeforeEach
    void before() {
        this.remoteStoragePath = Path.fromLocalFile((File)this.tempFolder).getPath();
    }

    @Test
    void testGetEmptyBuffer() {
        RemoteTierConsumerAgent remoteTierConsumerAgent = new RemoteTierConsumerAgent(new RemoteStorageScanner(this.remoteStoragePath), (PartitionFileReader)new TestingPartitionFileReader.Builder().build(), 1024);
        Assertions.assertThat((Optional)remoteTierConsumerAgent.getNextBuffer(new TieredStoragePartitionId(new ResultPartitionID()), new TieredStorageSubpartitionId(0), 0)).isEmpty();
    }

    @Test
    void testGetBuffer() {
        int bufferSize = 10;
        TestingPartitionFileReader partitionFileReader = new TestingPartitionFileReader.Builder().setReadBufferSupplier((bufferIndex, segmentId) -> new PartitionFileReader.ReadBufferResult(Collections.singletonList(BufferBuilderTestUtils.buildSomeBuffer(bufferSize)), false, null)).build();
        RemoteTierConsumerAgent remoteTierConsumerAgent = new RemoteTierConsumerAgent(new RemoteStorageScanner(this.remoteStoragePath), (PartitionFileReader)partitionFileReader, 1024);
        Optional optionalBuffer = remoteTierConsumerAgent.getNextBuffer(new TieredStoragePartitionId(new ResultPartitionID()), new TieredStorageSubpartitionId(0), 0);
        Assertions.assertThat((Optional)optionalBuffer).hasValueSatisfying(buffer -> Assertions.assertThat((int)buffer.readableBytes()).isEqualTo(bufferSize));
    }
}

