/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.util;

import java.nio.ByteBuffer;
import java.util.Random;
import java.util.concurrent.Callable;
import org.apache.flink.runtime.io.network.partition.BufferWritingResultPartition;
import org.apache.flink.runtime.io.network.util.TestProducerSource;
import org.apache.flink.util.Preconditions;

public class TestPartitionProducer
implements Callable<Boolean> {
    public static final int MAX_SLEEP_TIME_MS = 20;
    private final BufferWritingResultPartition partition;
    private final boolean isSlowProducer;
    private final TestProducerSource source;
    private final Random random;

    public TestPartitionProducer(BufferWritingResultPartition partition, boolean isSlowProducer, TestProducerSource source) {
        this.partition = (BufferWritingResultPartition)Preconditions.checkNotNull((Object)partition);
        this.isSlowProducer = isSlowProducer;
        this.random = isSlowProducer ? new Random() : null;
        this.source = (TestProducerSource)Preconditions.checkNotNull((Object)source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean call() throws Exception {
        boolean success = false;
        try {
            TestProducerSource.BufferAndChannel bufferAndChannel;
            while ((bufferAndChannel = this.source.getNextBuffer()) != null) {
                ByteBuffer record = ByteBuffer.wrap(bufferAndChannel.getBuffer());
                this.partition.emitRecord(record, bufferAndChannel.getTargetChannel());
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                if (!this.isSlowProducer) continue;
                Thread.sleep(this.random.nextInt(21));
            }
            this.partition.finish();
            success = true;
            Boolean bl = true;
            return bl;
        }
        finally {
            if (!success) {
                this.partition.release();
            }
        }
    }
}

