/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.registration;

import java.time.Duration;
import org.apache.flink.configuration.ClusterOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.runtime.registration.RetryingRegistrationConfiguration;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class RetryingRegistrationConfigurationTest
extends TestLogger {
    @Test
    public void testConfigurationParsing() {
        Configuration configuration = new Configuration();
        long initialRegistrationTimeout = 1L;
        long maxRegistrationTimeout = 2L;
        long refusedRegistrationDelay = 3L;
        long errorRegistrationDelay = 4L;
        configuration.setLong(ClusterOptions.INITIAL_REGISTRATION_TIMEOUT, 1L);
        configuration.setLong(ClusterOptions.MAX_REGISTRATION_TIMEOUT, 2L);
        configuration.setLong(ClusterOptions.REFUSED_REGISTRATION_DELAY, 3L);
        configuration.setLong(ClusterOptions.ERROR_REGISTRATION_DELAY, 4L);
        RetryingRegistrationConfiguration retryingRegistrationConfiguration = RetryingRegistrationConfiguration.fromConfiguration((Configuration)configuration);
        Assert.assertThat((Object)retryingRegistrationConfiguration.getInitialRegistrationTimeoutMillis(), (Matcher)Matchers.is((Object)1L));
        Assert.assertThat((Object)retryingRegistrationConfiguration.getMaxRegistrationTimeoutMillis(), (Matcher)Matchers.is((Object)2L));
        Assert.assertThat((Object)retryingRegistrationConfiguration.getRefusedDelayMillis(), (Matcher)Matchers.is((Object)3L));
        Assert.assertThat((Object)retryingRegistrationConfiguration.getErrorDelayMillis(), (Matcher)Matchers.is((Object)4L));
    }

    @Test
    public void testConfigurationWithDeprecatedOptions() {
        Configuration configuration = new Configuration();
        Duration refusedRegistrationBackoff = Duration.ofMinutes(42L);
        Duration registrationMaxBackoff = Duration.ofSeconds(1L);
        Duration initialRegistrationBackoff = Duration.ofHours(1337L);
        configuration.set(TaskManagerOptions.REFUSED_REGISTRATION_BACKOFF, (Object)refusedRegistrationBackoff);
        configuration.set(TaskManagerOptions.REGISTRATION_MAX_BACKOFF, (Object)registrationMaxBackoff);
        configuration.set(TaskManagerOptions.INITIAL_REGISTRATION_BACKOFF, (Object)initialRegistrationBackoff);
        RetryingRegistrationConfiguration retryingRegistrationConfiguration = RetryingRegistrationConfiguration.fromConfiguration((Configuration)configuration);
        Assert.assertThat((Object)retryingRegistrationConfiguration.getInitialRegistrationTimeoutMillis(), (Matcher)Matchers.is((Object)ClusterOptions.INITIAL_REGISTRATION_TIMEOUT.defaultValue()));
        Assert.assertThat((Object)retryingRegistrationConfiguration.getRefusedDelayMillis(), (Matcher)Matchers.is((Object)ClusterOptions.REFUSED_REGISTRATION_DELAY.defaultValue()));
        Assert.assertThat((Object)retryingRegistrationConfiguration.getMaxRegistrationTimeoutMillis(), (Matcher)Matchers.is((Object)ClusterOptions.MAX_REGISTRATION_TIMEOUT.defaultValue()));
    }
}

