/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest;

import java.util.Optional;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.io.network.netty.OutboundChannelHandlerFactory;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelDuplexHandler;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandler;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandlerContext;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelPromise;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpRequest;
import org.apache.flink.util.ConfigurationException;

public class Prio0OutboundChannelHandlerFactory
implements OutboundChannelHandlerFactory {
    public static final ConfigOption<String> REDIRECT_TO_URL = ConfigOptions.key((String)"test.out.redirect.to.url").stringType().defaultValue((Object)"");

    public int priority() {
        return 0;
    }

    public Optional<ChannelHandler> createHandler(Configuration configuration) throws ConfigurationException {
        final String redirectToUrl = configuration.getString(REDIRECT_TO_URL);
        if (!redirectToUrl.isEmpty()) {
            return Optional.of(new ChannelDuplexHandler(){

                public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
                    if (msg instanceof HttpRequest) {
                        HttpRequest httpRequest = (HttpRequest)msg;
                        httpRequest.setUri(redirectToUrl);
                    }
                    super.write(ctx, msg, promise);
                }
            });
        }
        return Optional.empty();
    }
}

