/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.BlobServerOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.runtime.blob.BlobCacheService;
import org.apache.flink.runtime.blob.BlobKey;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.blob.BlobServerPutTest;
import org.apache.flink.runtime.blob.BlobService;
import org.apache.flink.runtime.blob.BlobStore;
import org.apache.flink.runtime.blob.BlobStoreService;
import org.apache.flink.runtime.blob.BlobUtils;
import org.apache.flink.runtime.blob.TestingBlobUtils;
import org.apache.flink.testutils.junit.utils.TempDirUtils;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class BlobCacheSuccessTest {
    @TempDir
    private Path tempDir;

    BlobCacheSuccessTest() {
    }

    @Test
    void testBlobNoJobCache() throws IOException {
        Configuration config = new Configuration();
        config.set(BlobServerOptions.STORAGE_DIRECTORY, (Object)this.tempDir.toString());
        this.uploadFileGetTest(config, null, false, false, BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Test
    void testBlobForJobCache() throws IOException {
        Configuration config = new Configuration();
        config.set(BlobServerOptions.STORAGE_DIRECTORY, (Object)this.tempDir.toString());
        this.uploadFileGetTest(config, new JobID(), false, false, BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Test
    void testBlobForJobCacheHa() throws IOException {
        Configuration config = new Configuration();
        config.set(BlobServerOptions.STORAGE_DIRECTORY, (Object)TempDirUtils.newFolder((Path)this.tempDir).getAbsolutePath());
        config.set(HighAvailabilityOptions.HA_MODE, (Object)"ZOOKEEPER");
        config.set(HighAvailabilityOptions.HA_STORAGE_PATH, (Object)TempDirUtils.newFolder((Path)this.tempDir).getPath());
        this.uploadFileGetTest(config, new JobID(), true, true, BlobKey.BlobType.PERMANENT_BLOB);
    }

    @Test
    void testBlobForJobCacheHa2() throws IOException {
        Configuration config = new Configuration();
        config.set(BlobServerOptions.STORAGE_DIRECTORY, (Object)TempDirUtils.newFolder((Path)this.tempDir).getAbsolutePath());
        config.set(HighAvailabilityOptions.HA_MODE, (Object)"ZOOKEEPER");
        config.set(HighAvailabilityOptions.HA_STORAGE_PATH, (Object)TempDirUtils.newFolder((Path)this.tempDir).getPath());
        this.uploadFileGetTest(config, new JobID(), false, true, BlobKey.BlobType.PERMANENT_BLOB);
    }

    @Test
    void testBlobForJobCacheHaFallback() throws IOException {
        Configuration config = new Configuration();
        config.set(BlobServerOptions.STORAGE_DIRECTORY, (Object)TempDirUtils.newFolder((Path)this.tempDir).getAbsolutePath());
        config.set(HighAvailabilityOptions.HA_MODE, (Object)"ZOOKEEPER");
        config.set(HighAvailabilityOptions.HA_STORAGE_PATH, (Object)TempDirUtils.newFolder((Path)this.tempDir).getPath());
        this.uploadFileGetTest(config, new JobID(), false, false, BlobKey.BlobType.PERMANENT_BLOB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadFileGetTest(Configuration config, @Nullable JobID jobId, boolean shutdownServerAfterUpload, boolean cacheHasAccessToFs, BlobKey.BlobType blobType) throws IOException {
        Configuration cacheConfig = new Configuration(config);
        cacheConfig.set(BlobServerOptions.STORAGE_DIRECTORY, (Object)TempDirUtils.newFolder((Path)this.tempDir).getAbsolutePath());
        if (!cacheHasAccessToFs) {
            cacheConfig.set(HighAvailabilityOptions.HA_STORAGE_PATH, (Object)(TempDirUtils.newFolder((Path)this.tempDir).getPath() + "/does-not-exist"));
        }
        byte[] data = new byte[128];
        byte[] data2 = Arrays.copyOf(data, data.length);
        data2[0] = (byte)(data2[0] ^ 1);
        BlobStoreService blobStoreService = null;
        try {
            blobStoreService = BlobUtils.createBlobStoreFromConfig((Configuration)cacheConfig);
            Tuple2<BlobServer, BlobCacheService> serverAndCache = TestingBlobUtils.createServerAndCache(this.tempDir, config, cacheConfig, (BlobStore)blobStoreService, (BlobStore)blobStoreService);
            try (BlobServer server = (BlobServer)serverAndCache.f0;
                 BlobCacheService cache = (BlobCacheService)serverAndCache.f1;){
                server.start();
                BlobKey key1 = BlobServerPutTest.put((BlobService)server, jobId, data, blobType);
                BlobKey key2 = BlobServerPutTest.put((BlobService)server, jobId, data2, blobType);
                if (shutdownServerAfterUpload) {
                    server.close();
                }
                BlobServerPutTest.verifyContents((BlobService)cache, jobId, key1, data);
                BlobServerPutTest.verifyContents((BlobService)cache, jobId, key2, data2);
                if (shutdownServerAfterUpload) {
                    server.close();
                    BlobServerPutTest.verifyContents((BlobService)cache, jobId, key1, data);
                    BlobServerPutTest.verifyContents((BlobService)cache, jobId, key2, data2);
                }
            }
        }
        finally {
            if (blobStoreService != null) {
                blobStoreService.cleanupAllData();
                blobStoreService.close();
            }
        }
    }
}

