/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.DoubleSerializer;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.core.memory.ByteArrayInputStreamWithPos;
import org.apache.flink.core.memory.ByteArrayOutputStreamWithPos;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.runtime.state.KeyedBackendSerializationProxy;
import org.apache.flink.runtime.state.OperatorBackendSerializationProxy;
import org.apache.flink.runtime.state.OperatorStateHandle;
import org.apache.flink.runtime.state.RegisteredBroadcastStateBackendMetaInfo;
import org.apache.flink.runtime.state.RegisteredKeyValueStateBackendMetaInfo;
import org.apache.flink.runtime.state.RegisteredOperatorStateBackendMetaInfo;
import org.apache.flink.runtime.state.metainfo.StateMetaInfoReader;
import org.apache.flink.runtime.state.metainfo.StateMetaInfoSnapshot;
import org.apache.flink.runtime.state.metainfo.StateMetaInfoSnapshotReadersWriters;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class SerializationProxiesTest {
    SerializationProxiesTest() {
    }

    @Test
    void testKeyedBackendSerializationProxyRoundtrip() throws Exception {
        byte[] serialized;
        IntSerializer keySerializer = IntSerializer.INSTANCE;
        LongSerializer namespaceSerializer = LongSerializer.INSTANCE;
        DoubleSerializer stateSerializer = DoubleSerializer.INSTANCE;
        ArrayList<StateMetaInfoSnapshot> stateMetaInfoList = new ArrayList<StateMetaInfoSnapshot>();
        stateMetaInfoList.add(new RegisteredKeyValueStateBackendMetaInfo(StateDescriptor.Type.VALUE, "a", (TypeSerializer)namespaceSerializer, (TypeSerializer)stateSerializer).snapshot());
        stateMetaInfoList.add(new RegisteredKeyValueStateBackendMetaInfo(StateDescriptor.Type.VALUE, "b", (TypeSerializer)namespaceSerializer, (TypeSerializer)stateSerializer).snapshot());
        stateMetaInfoList.add(new RegisteredKeyValueStateBackendMetaInfo(StateDescriptor.Type.VALUE, "c", (TypeSerializer)namespaceSerializer, (TypeSerializer)stateSerializer).snapshot());
        KeyedBackendSerializationProxy serializationProxy = new KeyedBackendSerializationProxy((TypeSerializer)keySerializer, stateMetaInfoList, true);
        try (ByteArrayOutputStreamWithPos out = new ByteArrayOutputStreamWithPos();){
            serializationProxy.write((DataOutputView)new DataOutputViewStreamWrapper((OutputStream)out));
            serialized = out.toByteArray();
        }
        serializationProxy = new KeyedBackendSerializationProxy(Thread.currentThread().getContextClassLoader());
        var8_7 = null;
        try (ByteArrayInputStreamWithPos in = new ByteArrayInputStreamWithPos(serialized);){
            serializationProxy.read((DataInputView)new DataInputViewStreamWrapper((InputStream)in));
        }
        catch (Throwable throwable) {
            var8_7 = throwable;
            throw throwable;
        }
        Assertions.assertThat((boolean)serializationProxy.isUsingKeyGroupCompression()).isTrue();
        Assertions.assertThat((Object)serializationProxy.getKeySerializerSnapshot()).isInstanceOf(IntSerializer.IntSerializerSnapshot.class);
        this.assertEqualStateMetaInfoSnapshotsLists(stateMetaInfoList, serializationProxy.getStateMetaInfoSnapshots());
    }

    @Test
    void testKeyedStateMetaInfoSerialization() throws Exception {
        byte[] serialized;
        String name = "test";
        LongSerializer namespaceSerializer = LongSerializer.INSTANCE;
        DoubleSerializer stateSerializer = DoubleSerializer.INSTANCE;
        StateMetaInfoSnapshot metaInfo = new RegisteredKeyValueStateBackendMetaInfo(StateDescriptor.Type.VALUE, name, (TypeSerializer)namespaceSerializer, (TypeSerializer)stateSerializer).snapshot();
        try (ByteArrayOutputStreamWithPos out = new ByteArrayOutputStreamWithPos();){
            StateMetaInfoSnapshotReadersWriters.getWriter().writeStateMetaInfoSnapshot(metaInfo, (DataOutputView)new DataOutputViewStreamWrapper((OutputStream)out));
            serialized = out.toByteArray();
        }
        var7_6 = null;
        try (ByteArrayInputStreamWithPos in = new ByteArrayInputStreamWithPos(serialized);){
            StateMetaInfoReader reader = StateMetaInfoSnapshotReadersWriters.getReader((int)7);
            metaInfo = reader.readStateMetaInfoSnapshot((DataInputView)new DataInputViewStreamWrapper((InputStream)in), Thread.currentThread().getContextClassLoader());
        }
        catch (Throwable throwable) {
            var7_6 = throwable;
            throw throwable;
        }
        Assertions.assertThat((String)metaInfo.getName()).isEqualTo(name);
    }

    @Test
    void testOperatorBackendSerializationProxyRoundtrip() throws Exception {
        byte[] serialized;
        DoubleSerializer stateSerializer = DoubleSerializer.INSTANCE;
        DoubleSerializer keySerializer = DoubleSerializer.INSTANCE;
        StringSerializer valueSerializer = StringSerializer.INSTANCE;
        ArrayList<StateMetaInfoSnapshot> stateMetaInfoSnapshots = new ArrayList<StateMetaInfoSnapshot>();
        stateMetaInfoSnapshots.add(new RegisteredOperatorStateBackendMetaInfo("a", (TypeSerializer)stateSerializer, OperatorStateHandle.Mode.SPLIT_DISTRIBUTE).snapshot());
        stateMetaInfoSnapshots.add(new RegisteredOperatorStateBackendMetaInfo("b", (TypeSerializer)stateSerializer, OperatorStateHandle.Mode.SPLIT_DISTRIBUTE).snapshot());
        stateMetaInfoSnapshots.add(new RegisteredOperatorStateBackendMetaInfo("c", (TypeSerializer)stateSerializer, OperatorStateHandle.Mode.UNION).snapshot());
        ArrayList<StateMetaInfoSnapshot> broadcastStateMetaInfoSnapshots = new ArrayList<StateMetaInfoSnapshot>();
        broadcastStateMetaInfoSnapshots.add(new RegisteredBroadcastStateBackendMetaInfo("d", OperatorStateHandle.Mode.BROADCAST, (TypeSerializer)keySerializer, (TypeSerializer)valueSerializer).snapshot());
        broadcastStateMetaInfoSnapshots.add(new RegisteredBroadcastStateBackendMetaInfo("e", OperatorStateHandle.Mode.BROADCAST, (TypeSerializer)valueSerializer, (TypeSerializer)keySerializer).snapshot());
        OperatorBackendSerializationProxy serializationProxy = new OperatorBackendSerializationProxy(stateMetaInfoSnapshots, broadcastStateMetaInfoSnapshots, true);
        try (ByteArrayOutputStreamWithPos out = new ByteArrayOutputStreamWithPos();){
            serializationProxy.write((DataOutputView)new DataOutputViewStreamWrapper((OutputStream)out));
            serialized = out.toByteArray();
        }
        serializationProxy = new OperatorBackendSerializationProxy(Thread.currentThread().getContextClassLoader());
        var9_8 = null;
        try (ByteArrayInputStreamWithPos in = new ByteArrayInputStreamWithPos(serialized);){
            serializationProxy.read((DataInputView)new DataInputViewStreamWrapper((InputStream)in));
        }
        catch (Throwable throwable) {
            var9_8 = throwable;
            throw throwable;
        }
        Assertions.assertThat((boolean)serializationProxy.isUsingStateCompression()).isTrue();
        this.assertEqualStateMetaInfoSnapshotsLists(stateMetaInfoSnapshots, serializationProxy.getOperatorStateMetaInfoSnapshots());
        this.assertEqualStateMetaInfoSnapshotsLists(broadcastStateMetaInfoSnapshots, serializationProxy.getBroadcastStateMetaInfoSnapshots());
    }

    @Test
    void testOperatorStateMetaInfoSerialization() throws Exception {
        byte[] serialized;
        String name = "test";
        DoubleSerializer stateSerializer = DoubleSerializer.INSTANCE;
        StateMetaInfoSnapshot snapshot = new RegisteredOperatorStateBackendMetaInfo(name, (TypeSerializer)stateSerializer, OperatorStateHandle.Mode.UNION).snapshot();
        try (ByteArrayOutputStreamWithPos out = new ByteArrayOutputStreamWithPos();){
            StateMetaInfoSnapshotReadersWriters.getWriter().writeStateMetaInfoSnapshot(snapshot, (DataOutputView)new DataOutputViewStreamWrapper((OutputStream)out));
            serialized = out.toByteArray();
        }
        var6_5 = null;
        try (ByteArrayInputStreamWithPos in = new ByteArrayInputStreamWithPos(serialized);){
            StateMetaInfoReader reader = StateMetaInfoSnapshotReadersWriters.getReader((int)7);
            snapshot = reader.readStateMetaInfoSnapshot((DataInputView)new DataInputViewStreamWrapper((InputStream)in), Thread.currentThread().getContextClassLoader());
        }
        catch (Throwable throwable) {
            var6_5 = throwable;
            throw throwable;
        }
        RegisteredOperatorStateBackendMetaInfo restoredMetaInfo = new RegisteredOperatorStateBackendMetaInfo(snapshot);
        Assertions.assertThat((String)restoredMetaInfo.getName()).isEqualTo(name);
        Assertions.assertThat((Comparable)restoredMetaInfo.getAssignmentMode()).isEqualTo((Object)OperatorStateHandle.Mode.UNION);
        Assertions.assertThat((Object)restoredMetaInfo.getPartitionStateSerializer()).isEqualTo((Object)stateSerializer);
    }

    @Test
    void testBroadcastStateMetaInfoSerialization() throws Exception {
        byte[] serialized;
        String name = "test";
        DoubleSerializer keySerializer = DoubleSerializer.INSTANCE;
        StringSerializer valueSerializer = StringSerializer.INSTANCE;
        StateMetaInfoSnapshot snapshot = new RegisteredBroadcastStateBackendMetaInfo(name, OperatorStateHandle.Mode.BROADCAST, (TypeSerializer)keySerializer, (TypeSerializer)valueSerializer).snapshot();
        try (ByteArrayOutputStreamWithPos out = new ByteArrayOutputStreamWithPos();){
            StateMetaInfoSnapshotReadersWriters.getWriter().writeStateMetaInfoSnapshot(snapshot, (DataOutputView)new DataOutputViewStreamWrapper((OutputStream)out));
            serialized = out.toByteArray();
        }
        var7_6 = null;
        try (ByteArrayInputStreamWithPos in = new ByteArrayInputStreamWithPos(serialized);){
            StateMetaInfoReader reader = StateMetaInfoSnapshotReadersWriters.getReader((int)7);
            snapshot = reader.readStateMetaInfoSnapshot((DataInputView)new DataInputViewStreamWrapper((InputStream)in), Thread.currentThread().getContextClassLoader());
        }
        catch (Throwable throwable) {
            var7_6 = throwable;
            throw throwable;
        }
        RegisteredBroadcastStateBackendMetaInfo restoredMetaInfo = new RegisteredBroadcastStateBackendMetaInfo(snapshot);
        Assertions.assertThat((String)restoredMetaInfo.getName()).isEqualTo(name);
        Assertions.assertThat((Comparable)restoredMetaInfo.getAssignmentMode()).isEqualTo((Object)OperatorStateHandle.Mode.BROADCAST);
        Assertions.assertThat((Object)restoredMetaInfo.getKeySerializer()).isEqualTo((Object)keySerializer);
        Assertions.assertThat((Object)restoredMetaInfo.getValueSerializer()).isEqualTo((Object)valueSerializer);
    }

    @Test
    void testFixTypeOrder() {
        Assertions.assertThat((Object[])StateDescriptor.Type.values()).hasSize(7);
        Assertions.assertThat((int)StateDescriptor.Type.UNKNOWN.ordinal()).isZero();
        Assertions.assertThat((int)StateDescriptor.Type.VALUE.ordinal()).isOne();
        Assertions.assertThat((int)StateDescriptor.Type.LIST.ordinal()).isEqualTo(2);
        Assertions.assertThat((int)StateDescriptor.Type.REDUCING.ordinal()).isEqualTo(3);
        Assertions.assertThat((int)StateDescriptor.Type.FOLDING.ordinal()).isEqualTo(4);
        Assertions.assertThat((int)StateDescriptor.Type.AGGREGATING.ordinal()).isEqualTo(5);
        Assertions.assertThat((int)StateDescriptor.Type.MAP.ordinal()).isEqualTo(6);
    }

    private void assertEqualStateMetaInfoSnapshotsLists(List<StateMetaInfoSnapshot> expected, List<StateMetaInfoSnapshot> actual) {
        Assertions.assertThat(actual).hasSameSizeAs(expected);
        for (int i = 0; i < expected.size(); ++i) {
            this.assertEqualStateMetaInfoSnapshots(expected.get(i), actual.get(i));
        }
    }

    private void assertEqualStateMetaInfoSnapshots(StateMetaInfoSnapshot expected, StateMetaInfoSnapshot actual) {
        Assertions.assertThat((String)actual.getName()).isEqualTo(expected.getName());
        Assertions.assertThat((Comparable)actual.getBackendStateType()).isEqualTo((Object)expected.getBackendStateType());
        Assertions.assertThat((Map)actual.getOptionsImmutable()).isEqualTo((Object)expected.getOptionsImmutable());
        Assertions.assertThat((Map)actual.getSerializerSnapshotsImmutable()).isEqualTo((Object)expected.getSerializerSnapshotsImmutable());
    }
}

