/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.dump;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.Metric;
import org.apache.flink.metrics.SimpleCounter;
import org.apache.flink.metrics.util.TestHistogram;
import org.apache.flink.metrics.util.TestMeter;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.metrics.dump.MetricDumpSerialization;
import org.apache.flink.runtime.metrics.dump.MetricQueryService;
import org.apache.flink.runtime.metrics.groups.AbstractMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskManagerMetricGroup;
import org.apache.flink.runtime.metrics.groups.UnregisteredMetricGroups;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.rpc.TestingRpcService;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

class MetricQueryServiceTest {
    private static final Time TIMEOUT = Time.seconds((long)1L);
    private static TestingRpcService rpcService;

    MetricQueryServiceTest() {
    }

    @BeforeAll
    static void setupClass() {
        rpcService = new TestingRpcService();
    }

    @AfterEach
    void teardown() {
        rpcService.clearGateways();
    }

    @AfterAll
    static void teardownClass() {
        if (rpcService != null) {
            rpcService.closeAsync();
            rpcService = null;
        }
    }

    @Test
    void testCreateDump() throws Exception {
        MetricQueryService queryService = MetricQueryService.createMetricQueryService((RpcService)rpcService, (ResourceID)ResourceID.generate(), (long)Long.MAX_VALUE);
        queryService.start();
        SimpleCounter c = new SimpleCounter();
        Gauge g = () -> "Hello";
        TestHistogram h = new TestHistogram();
        TestMeter m = new TestMeter();
        TaskManagerMetricGroup tm = UnregisteredMetricGroups.createUnregisteredTaskManagerMetricGroup();
        queryService.addMetric("counter", (Metric)c, (AbstractMetricGroup)tm);
        queryService.addMetric("gauge", (Metric)g, (AbstractMetricGroup)tm);
        queryService.addMetric("histogram", (Metric)h, (AbstractMetricGroup)tm);
        queryService.addMetric("meter", (Metric)m, (AbstractMetricGroup)tm);
        MetricDumpSerialization.MetricSerializationResult dump = (MetricDumpSerialization.MetricSerializationResult)queryService.queryMetrics(TIMEOUT).get();
        Assertions.assertThat((byte[])dump.serializedCounters).isNotEmpty();
        Assertions.assertThat((byte[])dump.serializedGauges).isNotEmpty();
        Assertions.assertThat((byte[])dump.serializedHistograms).isNotEmpty();
        Assertions.assertThat((byte[])dump.serializedMeters).isNotEmpty();
        queryService.removeMetric((Metric)c);
        queryService.removeMetric((Metric)g);
        queryService.removeMetric((Metric)h);
        queryService.removeMetric((Metric)m);
        MetricDumpSerialization.MetricSerializationResult emptyDump = (MetricDumpSerialization.MetricSerializationResult)queryService.queryMetrics(TIMEOUT).get();
        Assertions.assertThat((byte[])emptyDump.serializedCounters).isEmpty();
        Assertions.assertThat((byte[])emptyDump.serializedGauges).isEmpty();
        Assertions.assertThat((byte[])emptyDump.serializedHistograms).isEmpty();
        Assertions.assertThat((byte[])emptyDump.serializedMeters).isEmpty();
    }

    @Test
    void testHandleOversizedMetricMessage() throws Exception {
        long sizeLimit = 200L;
        MetricQueryService queryService = MetricQueryService.createMetricQueryService((RpcService)rpcService, (ResourceID)ResourceID.generate(), (long)200L);
        queryService.start();
        TaskManagerMetricGroup tm = UnregisteredMetricGroups.createUnregisteredTaskManagerMetricGroup();
        String gaugeValue = "Hello";
        long requiredGaugesToExceedLimit = 200L / (long)"Hello".length() + 1L;
        List<Tuple2> gauges = LongStream.range(0L, requiredGaugesToExceedLimit).mapToObj(x -> Tuple2.of((Object)("gauge" + x), () -> "Hello" + x)).collect(Collectors.toList());
        gauges.forEach(gauge -> queryService.addMetric((String)gauge.f0, (Metric)gauge.f1, (AbstractMetricGroup)tm));
        queryService.addMetric("counter", (Metric)new SimpleCounter(), (AbstractMetricGroup)tm);
        queryService.addMetric("histogram", (Metric)new TestHistogram(), (AbstractMetricGroup)tm);
        queryService.addMetric("meter", (Metric)new TestMeter(), (AbstractMetricGroup)tm);
        MetricDumpSerialization.MetricSerializationResult dump = (MetricDumpSerialization.MetricSerializationResult)queryService.queryMetrics(TIMEOUT).get();
        Assertions.assertThat((byte[])dump.serializedCounters).isNotEmpty();
        Assertions.assertThat((int)dump.numCounters).isOne();
        Assertions.assertThat((byte[])dump.serializedMeters).isNotEmpty();
        Assertions.assertThat((int)dump.numMeters).isOne();
        Assertions.assertThat((byte[])dump.serializedGauges).isEmpty();
        Assertions.assertThat((int)dump.numGauges).isZero();
        Assertions.assertThat((byte[])dump.serializedHistograms).isNotEmpty();
        Assertions.assertThat((int)dump.numHistograms).isOne();
        for (int x2 = 1; x2 < gauges.size(); ++x2) {
            queryService.removeMetric((Metric)((Tuple2)gauges.get((int)x2)).f1);
        }
        MetricDumpSerialization.MetricSerializationResult recoveredDump = (MetricDumpSerialization.MetricSerializationResult)queryService.queryMetrics(TIMEOUT).get();
        Assertions.assertThat((byte[])recoveredDump.serializedCounters).isNotEmpty();
        Assertions.assertThat((int)recoveredDump.numCounters).isOne();
        Assertions.assertThat((byte[])recoveredDump.serializedMeters).isNotEmpty();
        Assertions.assertThat((int)recoveredDump.numMeters).isOne();
        Assertions.assertThat((byte[])recoveredDump.serializedGauges).isNotEmpty();
        Assertions.assertThat((int)recoveredDump.numGauges).isOne();
        Assertions.assertThat((byte[])recoveredDump.serializedHistograms).isNotEmpty();
        Assertions.assertThat((int)recoveredDump.numHistograms).isOne();
    }
}

