/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.sort;

import java.util.ArrayList;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.base.IntComparator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.operators.sort.MergeIterator;
import org.apache.flink.runtime.operators.testutils.TestData;
import org.apache.flink.util.MutableObjectIterator;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class MergeIteratorTest {
    private TypeComparator<Tuple2<Integer, String>> comparator;

    MergeIteratorTest() {
    }

    @BeforeEach
    void setup() {
        this.comparator = TestData.getIntStringTupleComparator();
    }

    private MutableObjectIterator<Tuple2<Integer, String>> newIterator(final int[] keys, final String[] values) {
        return new MutableObjectIterator<Tuple2<Integer, String>>(){
            private int key = 0;
            private String value = new String();
            private int current = 0;

            public Tuple2<Integer, String> next(Tuple2<Integer, String> reuse) {
                if (this.current < keys.length) {
                    this.key = keys[this.current];
                    this.value = values[this.current];
                    ++this.current;
                    reuse.setField((Object)this.key, 0);
                    reuse.setField((Object)this.value, 1);
                    return reuse;
                }
                return null;
            }

            public Tuple2<Integer, String> next() {
                if (this.current < keys.length) {
                    Tuple2 result = new Tuple2((Object)keys[this.current], (Object)values[this.current]);
                    ++this.current;
                    return result;
                }
                return null;
            }
        };
    }

    @Test
    void testMergeOfTwoStreams() throws Exception {
        ArrayList<MutableObjectIterator<Tuple2<Integer, String>>> iterators = new ArrayList<MutableObjectIterator<Tuple2<Integer, String>>>();
        iterators.add(this.newIterator(new int[]{1, 2, 4, 5, 10}, new String[]{"1", "2", "4", "5", "10"}));
        iterators.add(this.newIterator(new int[]{3, 6, 7, 10, 12}, new String[]{"3", "6", "7", "10", "12"}));
        int[] expected = new int[]{1, 2, 3, 4, 5, 6, 7, 10, 10, 12};
        IntComparator comparator = new IntComparator(true);
        MergeIterator iterator = new MergeIterator(iterators, this.comparator);
        Tuple2 rec1 = new Tuple2();
        Tuple2 rec2 = new Tuple2();
        int k1 = 0;
        int k2 = 0;
        int pos = 1;
        rec1 = (Tuple2)iterator.next((Object)rec1);
        Assertions.assertThat((Object)rec1).isNotNull();
        Assertions.assertThat((Integer)((Integer)rec1.f0)).isEqualTo(expected[0]);
        while ((rec2 = (Tuple2)iterator.next((Object)rec2)) != null) {
            k1 = (Integer)rec1.f0;
            k2 = (Integer)rec2.f0;
            Assertions.assertThat((int)comparator.compare((Object)k1, (Object)k2)).isLessThanOrEqualTo(0);
            Assertions.assertThat((int)k2).isEqualTo(expected[pos++]);
            Tuple2 tmp = rec1;
            rec1 = rec2;
            rec2 = tmp;
        }
    }

    @Test
    void testMergeOfTenStreams() throws Exception {
        ArrayList<MutableObjectIterator<Tuple2<Integer, String>>> iterators = new ArrayList<MutableObjectIterator<Tuple2<Integer, String>>>();
        iterators.add(this.newIterator(new int[]{1, 2, 17, 23, 23}, new String[]{"A", "B", "C", "D", "E"}));
        iterators.add(this.newIterator(new int[]{2, 6, 7, 8, 9}, new String[]{"A", "B", "C", "D", "E"}));
        iterators.add(this.newIterator(new int[]{4, 10, 11, 11, 12}, new String[]{"A", "B", "C", "D", "E"}));
        iterators.add(this.newIterator(new int[]{3, 6, 7, 10, 12}, new String[]{"A", "B", "C", "D", "E"}));
        iterators.add(this.newIterator(new int[]{7, 10, 15, 19, 44}, new String[]{"A", "B", "C", "D", "E"}));
        iterators.add(this.newIterator(new int[]{6, 6, 11, 17, 18}, new String[]{"A", "B", "C", "D", "E"}));
        iterators.add(this.newIterator(new int[]{1, 2, 4, 5, 10}, new String[]{"A", "B", "C", "D", "E"}));
        iterators.add(this.newIterator(new int[]{5, 10, 19, 23, 29}, new String[]{"A", "B", "C", "D", "E"}));
        iterators.add(this.newIterator(new int[]{9, 9, 9, 9, 9}, new String[]{"A", "B", "C", "D", "E"}));
        iterators.add(this.newIterator(new int[]{8, 8, 14, 14, 15}, new String[]{"A", "B", "C", "D", "E"}));
        IntComparator comparator = new IntComparator(true);
        MergeIterator iterator = new MergeIterator(iterators, this.comparator);
        int elementsFound = 1;
        Tuple2 rec1 = new Tuple2();
        Tuple2 rec2 = new Tuple2();
        rec1 = (Tuple2)iterator.next((Object)rec1);
        Assertions.assertThat((Object)rec1).isNotNull();
        while ((rec2 = (Tuple2)iterator.next((Object)rec2)) != null) {
            ++elementsFound;
            Assertions.assertThat((int)comparator.compare(rec1.f0, rec2.f0)).isLessThanOrEqualTo(0);
            Tuple2 tmp = rec1;
            rec1 = rec2;
            rec2 = tmp;
        }
        ((AbstractIntegerAssert)Assertions.assertThat((int)elementsFound).withFailMessage("Too few elements returned from stream.", new Object[0])).isEqualTo(50);
    }

    @Test
    void testInvalidMerge() throws Exception {
        ArrayList<MutableObjectIterator<Tuple2<Integer, String>>> iterators = new ArrayList<MutableObjectIterator<Tuple2<Integer, String>>>();
        iterators.add(this.newIterator(new int[]{1, 2, 17, 23, 23}, new String[]{"A", "B", "C", "D", "E"}));
        iterators.add(this.newIterator(new int[]{2, 6, 7, 8, 9}, new String[]{"A", "B", "C", "D", "E"}));
        iterators.add(this.newIterator(new int[]{4, 10, 11, 11, 12}, new String[]{"A", "B", "C", "D", "E"}));
        iterators.add(this.newIterator(new int[]{3, 6, 10, 7, 12}, new String[]{"A", "B", "C", "D", "E"}));
        iterators.add(this.newIterator(new int[]{7, 10, 15, 19, 44}, new String[]{"A", "B", "C", "D", "E"}));
        iterators.add(this.newIterator(new int[]{6, 6, 11, 17, 18}, new String[]{"A", "B", "C", "D", "E"}));
        iterators.add(this.newIterator(new int[]{1, 2, 4, 5, 10}, new String[]{"A", "B", "C", "D", "E"}));
        iterators.add(this.newIterator(new int[]{5, 10, 19, 23, 29}, new String[]{"A", "B", "C", "D", "E"}));
        iterators.add(this.newIterator(new int[]{9, 9, 9, 9, 9}, new String[]{"A", "B", "C", "D", "E"}));
        iterators.add(this.newIterator(new int[]{8, 8, 14, 14, 15}, new String[]{"A", "B", "C", "D", "E"}));
        IntComparator comparator = new IntComparator(true);
        MergeIterator iterator = new MergeIterator(iterators, this.comparator);
        boolean violationFound = false;
        Tuple2 rec1 = new Tuple2();
        Tuple2 rec2 = new Tuple2();
        rec1 = (Tuple2)iterator.next((Object)rec1);
        Assertions.assertThat((Object)rec1).isNotNull();
        while ((rec2 = (Tuple2)iterator.next((Object)rec2)) != null) {
            if (comparator.compare(rec1.f0, rec2.f0) > 0) {
                violationFound = true;
                break;
            }
            Tuple2 tmp = rec1;
            rec1 = rec2;
            rec2 = tmp;
        }
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)violationFound).withFailMessage("Merge must have returned a wrong result", new Object[0])).isTrue();
    }
}

