/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptive;

import java.time.Duration;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.core.testutils.CompletedScheduledFuture;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutor;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutorServiceAdapter;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.metrics.groups.JobManagerJobMetricGroup;
import org.apache.flink.runtime.metrics.groups.UnregisteredMetricGroups;
import org.apache.flink.runtime.scheduler.ExecutionGraphHandler;
import org.apache.flink.runtime.scheduler.GlobalFailureHandler;
import org.apache.flink.runtime.scheduler.OperatorCoordinatorHandler;
import org.apache.flink.runtime.scheduler.adaptive.CreatingExecutionGraph;
import org.apache.flink.runtime.scheduler.adaptive.JobSchedulingPlan;
import org.apache.flink.runtime.scheduler.adaptive.MockStateWithoutExecutionGraphContext;
import org.apache.flink.runtime.scheduler.adaptive.State;
import org.apache.flink.runtime.scheduler.adaptive.StateTrackingMockExecutionGraph;
import org.apache.flink.runtime.scheduler.adaptive.StateValidator;
import org.apache.flink.runtime.scheduler.adaptive.TestingOperatorCoordinatorHandler;
import org.apache.flink.runtime.scheduler.exceptionhistory.ExceptionHistoryEntry;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.concurrent.Executors;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CreatingExecutionGraphTest {
    private static final Logger LOG = LoggerFactory.getLogger(CreatingExecutionGraphTest.class);
    @RegisterExtension
    private MockCreatingExecutionGraphContext context = new MockCreatingExecutionGraphContext();

    CreatingExecutionGraphTest() {
    }

    @Test
    void testFailedExecutionGraphCreationTransitionsToFinished() {
        CompletableFuture executionGraphWithVertexParallelismFuture = new CompletableFuture();
        new CreatingExecutionGraph((CreatingExecutionGraph.Context)this.context, executionGraphWithVertexParallelismFuture, LOG, CreatingExecutionGraphTest::createTestingOperatorCoordinatorHandler, null);
        this.context.setExpectFinished(archivedExecutionGraph -> {
            AbstractComparableAssert cfr_ignored_0 = (AbstractComparableAssert)Assertions.assertThat((Comparable)archivedExecutionGraph.getState()).isEqualTo((Object)JobStatus.FAILED);
        });
        executionGraphWithVertexParallelismFuture.completeExceptionally((Throwable)new FlinkException("Test exception"));
    }

    @Test
    void testNotPossibleSlotAssignmentTransitionsToWaitingForResources() {
        CompletableFuture<CreatingExecutionGraph.ExecutionGraphWithVertexParallelism> executionGraphWithVertexParallelismFuture = new CompletableFuture<CreatingExecutionGraph.ExecutionGraphWithVertexParallelism>();
        new CreatingExecutionGraph((CreatingExecutionGraph.Context)this.context, executionGraphWithVertexParallelismFuture, LOG, CreatingExecutionGraphTest::createTestingOperatorCoordinatorHandler, null);
        this.context.setTryToAssignSlotsFunction(ignored -> CreatingExecutionGraph.AssignmentResult.notPossible());
        this.context.setExpectWaitingForResources();
        StateTrackingMockExecutionGraph executionGraph = new StateTrackingMockExecutionGraph();
        executionGraphWithVertexParallelismFuture.complete(CreatingExecutionGraphTest.getGraph(executionGraph));
        Assertions.assertThat((Comparable)executionGraph.getState()).isEqualTo((Object)JobStatus.INITIALIZING);
    }

    @Test
    void testSuccessfulSlotAssignmentTransitionsToExecuting() {
        CompletableFuture<CreatingExecutionGraph.ExecutionGraphWithVertexParallelism> executionGraphWithVertexParallelismFuture = new CompletableFuture<CreatingExecutionGraph.ExecutionGraphWithVertexParallelism>();
        new CreatingExecutionGraph((CreatingExecutionGraph.Context)this.context, executionGraphWithVertexParallelismFuture, LOG, CreatingExecutionGraphTest::createTestingOperatorCoordinatorHandler, null);
        StateTrackingMockExecutionGraph executionGraph = new StateTrackingMockExecutionGraph();
        this.context.setTryToAssignSlotsFunction(CreatingExecutionGraphTest::successfulAssignment);
        this.context.setExpectedExecuting(actualExecutionGraph -> {
            ObjectAssert cfr_ignored_0 = (ObjectAssert)Assertions.assertThat((Object)actualExecutionGraph).isEqualTo((Object)executionGraph);
        });
        executionGraphWithVertexParallelismFuture.complete(CreatingExecutionGraphTest.getGraph(executionGraph));
    }

    @Test
    void testOperatorCoordinatorUsesFailureHandlerOfTheCurrentState() {
        CompletableFuture<CreatingExecutionGraph.ExecutionGraphWithVertexParallelism> executionGraphWithVertexParallelismFuture = new CompletableFuture<CreatingExecutionGraph.ExecutionGraphWithVertexParallelism>();
        AtomicReference operatorCoordinatorGlobalFailureHandlerRef = new AtomicReference();
        new CreatingExecutionGraph((CreatingExecutionGraph.Context)this.context, executionGraphWithVertexParallelismFuture, LOG, (executionGraph, errorHandler) -> {
            operatorCoordinatorGlobalFailureHandlerRef.set(errorHandler);
            return new TestingOperatorCoordinatorHandler();
        }, null);
        StateTrackingMockExecutionGraph executionGraph2 = new StateTrackingMockExecutionGraph();
        this.context.setTryToAssignSlotsFunction(CreatingExecutionGraphTest::successfulAssignment);
        this.context.setExpectedExecuting(actualExecutionGraph -> {
            ObjectAssert cfr_ignored_0 = (ObjectAssert)Assertions.assertThat((Object)actualExecutionGraph).isEqualTo((Object)executionGraph2);
        });
        executionGraphWithVertexParallelismFuture.complete(CreatingExecutionGraphTest.getGraph(executionGraph2));
        Assertions.assertThat(operatorCoordinatorGlobalFailureHandlerRef.get()).isSameAs((Object)this.context);
    }

    private static CreatingExecutionGraph.AssignmentResult successfulAssignment(CreatingExecutionGraph.ExecutionGraphWithVertexParallelism executionGraphWithVertexParallelism) {
        return CreatingExecutionGraph.AssignmentResult.success((ExecutionGraph)executionGraphWithVertexParallelism.getExecutionGraph());
    }

    private static OperatorCoordinatorHandler createTestingOperatorCoordinatorHandler(ExecutionGraph executionGraph, GlobalFailureHandler globalFailureHandler) {
        return new TestingOperatorCoordinatorHandler();
    }

    private static CreatingExecutionGraph.ExecutionGraphWithVertexParallelism getGraph(StateTrackingMockExecutionGraph executionGraph) {
        return CreatingExecutionGraph.ExecutionGraphWithVertexParallelism.create((ExecutionGraph)executionGraph, (JobSchedulingPlan)JobSchedulingPlan.empty());
    }

    static class MockCreatingExecutionGraphContext
    extends MockStateWithoutExecutionGraphContext
    implements CreatingExecutionGraph.Context {
        private final StateValidator<Void> waitingForResourcesStateValidator = new StateValidator("WaitingForResources");
        private final StateValidator<ExecutionGraph> executingStateValidator = new StateValidator("Executing");
        private Function<CreatingExecutionGraph.ExecutionGraphWithVertexParallelism, CreatingExecutionGraph.AssignmentResult> tryToAssignSlotsFunction = e -> CreatingExecutionGraph.AssignmentResult.success((ExecutionGraph)e.getExecutionGraph());
        private GlobalFailureHandler globalFailureHandler = t -> {};

        MockCreatingExecutionGraphContext() {
        }

        public void setExpectWaitingForResources() {
            this.waitingForResourcesStateValidator.expectInput(none -> {});
        }

        public void setExpectedExecuting(Consumer<ExecutionGraph> asserter) {
            this.executingStateValidator.expectInput(asserter);
        }

        public void setTryToAssignSlotsFunction(Function<CreatingExecutionGraph.ExecutionGraphWithVertexParallelism, CreatingExecutionGraph.AssignmentResult> tryToAssignSlotsFunction) {
            this.tryToAssignSlotsFunction = tryToAssignSlotsFunction;
        }

        public void setGlobalFailureHandler(GlobalFailureHandler globalFailureHandler) {
            this.globalFailureHandler = globalFailureHandler;
        }

        public void goToExecuting(ExecutionGraph executionGraph, ExecutionGraphHandler executionGraphHandler, OperatorCoordinatorHandler operatorCoordinatorHandler, List<ExceptionHistoryEntry> failureCollection) {
            this.executingStateValidator.validateInput(executionGraph);
            this.registerStateTransition();
        }

        public ScheduledFuture<?> runIfState(State expectedState, Runnable action, Duration delay) {
            if (!this.hasStateTransition()) {
                action.run();
            }
            return CompletedScheduledFuture.create(null);
        }

        public void handleGlobalFailure(Throwable cause) {
            this.globalFailureHandler.handleGlobalFailure(cause);
        }

        public CreatingExecutionGraph.AssignmentResult tryToAssignSlots(CreatingExecutionGraph.ExecutionGraphWithVertexParallelism executionGraphWithVertexParallelism) {
            return this.tryToAssignSlotsFunction.apply(executionGraphWithVertexParallelism);
        }

        public void goToWaitingForResources(@Nullable ExecutionGraph previousExecutionGraph) {
            this.waitingForResourcesStateValidator.validateInput(null);
            this.registerStateTransition();
        }

        public Executor getIOExecutor() {
            return Executors.directExecutor();
        }

        public ComponentMainThreadExecutor getMainThreadExecutor() {
            return ComponentMainThreadExecutorServiceAdapter.forMainThread();
        }

        public JobManagerJobMetricGroup getMetricGroup() {
            return UnregisteredMetricGroups.createUnregisteredJobManagerJobMetricGroup();
        }

        @Override
        public void afterEach(ExtensionContext extensionContext) throws Exception {
            super.afterEach(extensionContext);
            this.waitingForResourcesStateValidator.close();
            this.executingStateValidator.close();
        }
    }
}

