/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptive;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.ErrorInfo;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.TaskExecutionStateTransition;
import org.apache.flink.runtime.failure.FailureEnricherUtils;
import org.apache.flink.runtime.scheduler.ExecutionGraphHandler;
import org.apache.flink.runtime.scheduler.OperatorCoordinatorHandler;
import org.apache.flink.runtime.scheduler.adaptive.ExecutingTest;
import org.apache.flink.runtime.scheduler.adaptive.Failing;
import org.apache.flink.runtime.scheduler.adaptive.MockStateWithExecutionGraphContext;
import org.apache.flink.runtime.scheduler.adaptive.StateTrackingMockExecutionGraph;
import org.apache.flink.runtime.scheduler.adaptive.StateValidator;
import org.apache.flink.runtime.scheduler.adaptive.TestingOperatorCoordinatorHandler;
import org.apache.flink.runtime.scheduler.adaptive.WaitingForResourcesTest;
import org.apache.flink.runtime.scheduler.exceptionhistory.ExceptionHistoryEntry;
import org.apache.flink.runtime.scheduler.exceptionhistory.RootExceptionHistoryEntry;
import org.apache.flink.runtime.scheduler.exceptionhistory.TestingAccessExecution;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FailingTest {
    private static final Logger log = LoggerFactory.getLogger(FailingTest.class);
    private final Throwable testFailureCause = new RuntimeException();

    FailingTest() {
    }

    @Test
    void testFailingStateOnEnter() throws Exception {
        try (MockFailingContext ctx = new MockFailingContext();){
            StateTrackingMockExecutionGraph meg = new StateTrackingMockExecutionGraph();
            this.createFailingState(ctx, meg);
            Assertions.assertThat((Comparable)meg.getState()).isEqualTo((Object)JobStatus.FAILING);
            ctx.assertNoStateTransition();
        }
    }

    @Test
    void testTransitionToFailedWhenFailingCompletes() throws Exception {
        try (MockFailingContext ctx = new MockFailingContext();){
            StateTrackingMockExecutionGraph meg = new StateTrackingMockExecutionGraph();
            Failing failing = this.createFailingState(ctx, meg);
            ctx.setExpectFinished(archivedExecutionGraph -> {
                AbstractComparableAssert cfr_ignored_0 = (AbstractComparableAssert)Assertions.assertThat((Comparable)archivedExecutionGraph.getState()).isEqualTo((Object)JobStatus.FAILED);
            });
            meg.completeTerminationFuture(JobStatus.FAILED);
        }
    }

    @Test
    void testTransitionToCancelingOnCancel() throws Exception {
        try (MockFailingContext ctx = new MockFailingContext();){
            StateTrackingMockExecutionGraph meg = new StateTrackingMockExecutionGraph();
            Failing failing = this.createFailingState(ctx, meg);
            ctx.setExpectCanceling(WaitingForResourcesTest.assertNonNull());
            failing.cancel();
        }
    }

    @Test
    void testTransitionToFinishedOnSuspend() throws Exception {
        try (MockFailingContext ctx = new MockFailingContext();){
            StateTrackingMockExecutionGraph meg = new StateTrackingMockExecutionGraph();
            Failing failing = this.createFailingState(ctx, meg);
            ctx.setExpectFinished(archivedExecutionGraph -> {
                AbstractComparableAssert cfr_ignored_0 = (AbstractComparableAssert)Assertions.assertThat((Comparable)archivedExecutionGraph.getState()).isEqualTo((Object)JobStatus.SUSPENDED);
            });
            failing.suspend((Throwable)new RuntimeException("suspend"));
        }
    }

    @Test
    void testIgnoreGlobalFailure() throws Exception {
        try (MockFailingContext ctx = new MockFailingContext();){
            StateTrackingMockExecutionGraph meg = new StateTrackingMockExecutionGraph();
            Failing failing = this.createFailingState(ctx, meg);
            failing.handleGlobalFailure((Throwable)new RuntimeException(), FailureEnricherUtils.EMPTY_FAILURE_LABELS);
            ctx.assertNoStateTransition();
        }
    }

    @Test
    void testTaskFailuresAreIgnored() throws Exception {
        try (MockFailingContext ctx = new MockFailingContext();){
            StateTrackingMockExecutionGraph meg = new StateTrackingMockExecutionGraph();
            Failing failing = this.createFailingState(ctx, meg);
            RuntimeException exception = new RuntimeException();
            TestingAccessExecution execution = TestingAccessExecution.newBuilder().withExecutionState(ExecutionState.FAILED).withErrorInfo(new ErrorInfo((Throwable)exception, System.currentTimeMillis())).build();
            meg.registerExecution(execution);
            TaskExecutionStateTransition update = ExecutingTest.createFailingStateTransition(execution.getAttemptId(), exception);
            failing.updateTaskExecutionState(update, FailureEnricherUtils.EMPTY_FAILURE_LABELS);
            ctx.assertNoStateTransition();
        }
    }

    @Test
    void testStateDoesNotExposeGloballyTerminalExecutionGraph() throws Exception {
        try (MockFailingContext ctx = new MockFailingContext();){
            StateTrackingMockExecutionGraph meg = new StateTrackingMockExecutionGraph();
            Failing failing = this.createFailingState(ctx, meg);
            ctx.setExpectFinished(eg -> {});
            meg.completeTerminationFuture(JobStatus.FAILED);
            Assertions.assertThat((Comparable)meg.getState()).isEqualTo((Object)JobStatus.FAILED);
            Assertions.assertThat((Comparable)failing.getJobStatus()).isEqualTo((Object)JobStatus.FAILING);
            Assertions.assertThat((Comparable)failing.getJob().getState()).isEqualTo((Object)JobStatus.FAILING);
            Assertions.assertThat((long)failing.getJob().getStatusTimestamp(JobStatus.FAILED)).isZero();
        }
    }

    private Failing createFailingState(MockFailingContext ctx, ExecutionGraph executionGraph) {
        ExecutionGraphHandler executionGraphHandler = new ExecutionGraphHandler(executionGraph, log, (Executor)ctx.getMainThreadExecutor(), ctx.getMainThreadExecutor());
        TestingOperatorCoordinatorHandler operatorCoordinatorHandler = new TestingOperatorCoordinatorHandler();
        executionGraph.transitionToRunning();
        return new Failing((Failing.Context)ctx, executionGraph, executionGraphHandler, (OperatorCoordinatorHandler)operatorCoordinatorHandler, log, this.testFailureCause, ClassLoader.getSystemClassLoader(), new ArrayList());
    }

    private static class MockFailingContext
    extends MockStateWithExecutionGraphContext
    implements Failing.Context {
        private final StateValidator<ExecutingTest.CancellingArguments> cancellingStateValidator = new StateValidator("cancelling");

        private MockFailingContext() {
        }

        public void setExpectCanceling(Consumer<ExecutingTest.CancellingArguments> asserter) {
            this.cancellingStateValidator.expectInput(asserter);
        }

        @Override
        public void archiveFailure(RootExceptionHistoryEntry failure) {
        }

        public void goToCanceling(ExecutionGraph executionGraph, ExecutionGraphHandler executionGraphHandler, OperatorCoordinatorHandler operatorCoordinatorHandler, List<ExceptionHistoryEntry> failureCollection) {
            this.cancellingStateValidator.validateInput(new ExecutingTest.CancellingArguments(executionGraph, executionGraphHandler, operatorCoordinatorHandler));
            this.hadStateTransition = true;
        }

        @Override
        public void close() throws Exception {
            super.close();
            this.cancellingStateValidator.close();
        }
    }
}

