/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.EnumMap;
import java.util.UUID;
import org.apache.flink.runtime.state.DirectoryStateHandle;
import org.apache.flink.runtime.state.IncrementalLocalKeyedStateHandle;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.StateObject;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.state.memory.ByteStreamStateHandle;
import org.apache.flink.util.Preconditions;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class IncrementalLocalKeyedStateHandleTest {
    @Test
    public void testDirectorySize(@TempDir Path directory) throws IOException {
        int metaDataBytes = 42;
        ByteStreamStateHandle metaDataStateHandle = new ByteStreamStateHandle("MetaDataTest", new byte[42]);
        int fileOneBytes = 1024;
        File outputFile = new File(directory.toFile(), "out.001");
        try (FileOutputStream outputStream = new FileOutputStream(outputFile);){
            outputStream.write(new byte[1024]);
        }
        File subPath = new File(directory.toFile(), "subdir");
        Preconditions.checkState((boolean)subPath.mkdirs());
        int fileTwoBytes = 128;
        outputFile = new File(subPath, "out.002");
        try (FileOutputStream outputStream = new FileOutputStream(outputFile);){
            outputStream.write(new byte[128]);
        }
        DirectoryStateHandle directoryStateHandle = DirectoryStateHandle.forPathWithSize((Path)directory);
        IncrementalLocalKeyedStateHandle handle = new IncrementalLocalKeyedStateHandle(UUID.randomUUID(), 0L, directoryStateHandle, new KeyGroupRange(0, 1), (StreamStateHandle)metaDataStateHandle, Collections.emptyList());
        StateObject.StateObjectSizeStatsCollector stats = StateObject.StateObjectSizeStatsCollector.create();
        handle.collectSizeStats(stats);
        Assertions.assertEquals((long)1194L, (long)this.extractLocalStateSizes(stats));
    }

    private long extractLocalStateSizes(StateObject.StateObjectSizeStatsCollector stats) {
        EnumMap statsMap = stats.getStats();
        Assertions.assertFalse((boolean)statsMap.containsKey(StateObject.StateObjectLocation.REMOTE));
        Assertions.assertFalse((boolean)statsMap.containsKey(StateObject.StateObjectLocation.UNKNOWN));
        return (Long)statsMap.get(StateObject.StateObjectLocation.LOCAL_DISK) + (Long)statsMap.get(StateObject.StateObjectLocation.LOCAL_MEMORY);
    }
}

