/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.checkpoint.TaskState;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.util.Preconditions;

public class CompletedCheckpoint
implements Serializable {
    private static final long serialVersionUID = -8360248179615702014L;
    private final JobID job;
    private final long checkpointID;
    private final long timestamp;
    private final long duration;
    private final Map<JobVertexID, TaskState> taskStates;

    public CompletedCheckpoint(JobID job, long checkpointID, long timestamp, long completionTimestamp, Map<JobVertexID, TaskState> taskStates) {
        this.job = job;
        this.checkpointID = checkpointID;
        this.timestamp = timestamp;
        this.duration = completionTimestamp - timestamp;
        this.taskStates = (Map)Preconditions.checkNotNull(taskStates);
    }

    public JobID getJobId() {
        return this.job;
    }

    public long getCheckpointID() {
        return this.checkpointID;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getDuration() {
        return this.duration;
    }

    public long getStateSize() {
        long result = 0L;
        for (TaskState taskState : this.taskStates.values()) {
            result += taskState.getStateSize();
        }
        return result;
    }

    public Map<JobVertexID, TaskState> getTaskStates() {
        return this.taskStates;
    }

    public TaskState getTaskState(JobVertexID jobVertexID) {
        return this.taskStates.get((Object)jobVertexID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discard(ClassLoader userClassLoader) throws Exception {
        try {
            for (TaskState state : this.taskStates.values()) {
                state.discard(userClassLoader);
            }
        }
        finally {
            this.taskStates.clear();
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof CompletedCheckpoint) {
            CompletedCheckpoint other = (CompletedCheckpoint)obj;
            return this.job.equals((Object)other.job) && this.checkpointID == other.checkpointID && this.timestamp == other.timestamp && this.duration == other.duration && this.taskStates.equals(other.taskStates);
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.checkpointID ^ this.checkpointID >>> 32) + 31 * ((int)(this.timestamp ^ this.timestamp >>> 32) + 31 * ((int)(this.duration ^ this.duration >>> 32) + 31 * Objects.hash(this.job, this.taskStates)));
    }

    public String toString() {
        return String.format("Checkpoint %d @ %d for %s", this.checkpointID, this.timestamp, this.job);
    }
}

