/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.clusterframework;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.configuration.Configuration;

public class ContaineredTaskManagerParameters
implements Serializable {
    private static final long serialVersionUID = -3096987654278064670L;
    private final long totalContainerMemoryMB;
    private final long taskManagerHeapSizeMB;
    private final long taskManagerDirectMemoryLimitMB;
    private final int numSlots;
    private final HashMap<String, String> taskManagerEnv;

    public ContaineredTaskManagerParameters(long totalContainerMemoryMB, long taskManagerHeapSizeMB, long taskManagerDirectMemoryLimitMB, int numSlots, HashMap<String, String> taskManagerEnv) {
        this.totalContainerMemoryMB = totalContainerMemoryMB;
        this.taskManagerHeapSizeMB = taskManagerHeapSizeMB;
        this.taskManagerDirectMemoryLimitMB = taskManagerDirectMemoryLimitMB;
        this.numSlots = numSlots;
        this.taskManagerEnv = taskManagerEnv;
    }

    public long taskManagerTotalMemoryMB() {
        return this.totalContainerMemoryMB;
    }

    public long taskManagerHeapSizeMB() {
        return this.taskManagerHeapSizeMB;
    }

    public long taskManagerDirectMemoryLimitMB() {
        return this.taskManagerDirectMemoryLimitMB;
    }

    public int numSlots() {
        return this.numSlots;
    }

    public Map<String, String> taskManagerEnv() {
        return this.taskManagerEnv;
    }

    public String toString() {
        return "TaskManagerParameters {totalContainerMemory=" + this.totalContainerMemoryMB + ", taskManagerHeapSize=" + this.taskManagerHeapSizeMB + ", taskManagerDirectMemoryLimit=" + this.taskManagerDirectMemoryLimitMB + ", numSlots=" + this.numSlots + ", taskManagerEnv=" + this.taskManagerEnv + '}';
    }

    public static ContaineredTaskManagerParameters create(Configuration config, long containerMemoryMB, int numSlots) {
        long heapSizeMB;
        float memoryCutoffRatio = config.getFloat("containerized.heap-cutoff-ratio", 0.25f);
        int minCutoff = config.getInteger("containerized.heap-cutoff-min", 600);
        if (memoryCutoffRatio >= 1.0f || memoryCutoffRatio <= 0.0f) {
            throw new IllegalArgumentException("The configuration value 'containerized.heap-cutoff-ratio' must be between 0 and 1. Value given=" + memoryCutoffRatio);
        }
        if ((long)minCutoff >= containerMemoryMB) {
            throw new IllegalArgumentException("The configuration value 'containerized.heap-cutoff-min'='" + minCutoff + "' is larger than the total container memory " + containerMemoryMB);
        }
        long cutoff = (long)((float)containerMemoryMB * memoryCutoffRatio);
        if (cutoff < (long)minCutoff) {
            cutoff = minCutoff;
        }
        long javaMemorySizeMB = containerMemoryMB - cutoff;
        boolean useOffHeap = config.getBoolean("taskmanager.memory.off-heap", false);
        if (useOffHeap) {
            long offHeapSize = config.getLong("taskmanager.memory.size", -1L);
            if (offHeapSize <= 0L) {
                double fraction = config.getFloat("taskmanager.memory.fraction", 0.7f);
                offHeapSize = (long)(fraction * (double)javaMemorySizeMB);
            }
            heapSizeMB = javaMemorySizeMB - offHeapSize;
        } else {
            heapSizeMB = javaMemorySizeMB;
        }
        HashMap<String, String> envVars = new HashMap<String, String>();
        String prefix = "containerized.taskmanager.env.";
        for (String key : config.keySet()) {
            if (!key.startsWith("containerized.taskmanager.env.") || key.length() <= "containerized.taskmanager.env.".length()) continue;
            String envVarKey = key.substring("containerized.taskmanager.env.".length());
            envVars.put(envVarKey, config.getString(key, null));
        }
        return new ContaineredTaskManagerParameters(containerMemoryMB, heapSizeMB, javaMemorySizeMB, numSlots, envVars);
    }
}

