/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.api.serialization;

import java.io.IOException;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.metrics.groups.IOMetricGroup;
import org.apache.flink.runtime.accumulators.AccumulatorRegistry;
import org.apache.flink.runtime.io.network.buffer.Buffer;

public interface RecordSerializer<T extends IOReadableWritable> {
    public SerializationResult addRecord(T var1) throws IOException;

    public SerializationResult setNextBuffer(Buffer var1) throws IOException;

    public Buffer getCurrentBuffer();

    public void clearCurrentBuffer();

    public void clear();

    public boolean hasData();

    public void setReporter(AccumulatorRegistry.Reporter var1);

    public void instantiateMetrics(IOMetricGroup var1);

    public static enum SerializationResult {
        PARTIAL_RECORD_MEMORY_SEGMENT_FULL(false, true),
        FULL_RECORD_MEMORY_SEGMENT_FULL(true, true),
        FULL_RECORD(true, false);

        private final boolean isFullRecord;
        private final boolean isFullBuffer;

        private SerializationResult(boolean isFullRecord, boolean isFullBuffer) {
            this.isFullRecord = isFullRecord;
            this.isFullBuffer = isFullBuffer;
        }

        public boolean isFullRecord() {
            return this.isFullRecord;
        }

        public boolean isFullBuffer() {
            return this.isFullBuffer;
        }
    }
}

