/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager;

import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.configuration.Configuration;

public enum RecoveryMode {
    STANDALONE,
    ZOOKEEPER;


    public static RecoveryMode fromConfig(Configuration config) {
        return RecoveryMode.valueOf(config.getString("recovery.mode", ConfigConstants.DEFAULT_RECOVERY_MODE).toUpperCase());
    }

    public static boolean isHighAvailabilityModeActivated(Configuration configuration) {
        String recoveryMode = configuration.getString("recovery.mode", ConfigConstants.DEFAULT_RECOVERY_MODE).toUpperCase();
        RecoveryMode mode = RecoveryMode.valueOf(recoveryMode);
        switch (mode) {
            case STANDALONE: {
                return false;
            }
            case ZOOKEEPER: {
                return true;
            }
        }
        return false;
    }
}

