/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager.scheduler;

import org.apache.flink.runtime.instance.Instance;
import org.apache.flink.runtime.instance.SharedSlot;
import org.apache.flink.runtime.jobmanager.scheduler.CoLocationGroup;
import org.apache.flink.util.AbstractID;
import org.apache.flink.util.Preconditions;

public class CoLocationConstraint {
    private final CoLocationGroup group;
    private volatile SharedSlot sharedSlot;
    private volatile boolean locationLocked;

    CoLocationConstraint(CoLocationGroup group) {
        Preconditions.checkNotNull((Object)group);
        this.group = group;
    }

    public SharedSlot getSharedSlot() {
        return this.sharedSlot;
    }

    public AbstractID getGroupId() {
        return this.group.getId();
    }

    public boolean isAssigned() {
        return this.locationLocked;
    }

    public boolean isAssignedAndAlive() {
        return this.locationLocked && this.sharedSlot.isAlive();
    }

    public Instance getLocation() {
        if (this.locationLocked) {
            return this.sharedSlot.getInstance();
        }
        throw new IllegalStateException("Location not yet locked");
    }

    public void setSharedSlot(SharedSlot newSlot) {
        if (this.sharedSlot == null) {
            this.sharedSlot = newSlot;
        } else if (newSlot != this.sharedSlot) {
            if (this.locationLocked && this.sharedSlot.getInstance() != newSlot.getInstance()) {
                throw new IllegalArgumentException("Cannot assign different location to a constraint whose location is locked.");
            }
            if (this.sharedSlot.isAlive()) {
                this.sharedSlot.releaseSlot();
            }
            this.sharedSlot = newSlot;
        }
    }

    public void lockLocation() throws IllegalStateException {
        if (this.locationLocked) {
            throw new IllegalStateException("Location is already locked");
        }
        if (this.sharedSlot == null) {
            throw new IllegalStateException("Cannot lock location without a slot.");
        }
        this.locationLocked = true;
    }

    public String toString() {
        return "CoLocation constraint id " + this.getGroupId() + " shared slot " + this.sharedSlot;
    }
}

