/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public abstract class AbstractCloseableHandle
implements Closeable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final AtomicIntegerFieldUpdater<AbstractCloseableHandle> CLOSER = AtomicIntegerFieldUpdater.newUpdater(AbstractCloseableHandle.class, "isClosed");
    private volatile transient Closeable toClose;
    private volatile transient int isClosed;

    protected final void registerCloseable(Closeable toClose) throws IOException {
        if (toClose == null) {
            return;
        }
        this.toClose = toClose;
        if (this.isClosed != 0) {
            toClose.close();
            throw new IOException("handle is closed");
        }
    }

    @Override
    public final void close() throws IOException {
        Closeable toClose;
        if (CLOSER.compareAndSet(this, 0, 1) && (toClose = this.toClose) != null) {
            this.toClose = null;
            toClose.close();
        }
    }

    public boolean isClosed() {
        return this.isClosed != 0;
    }

    public void ensureNotClosed() throws IOException {
        if (this.isClosed != 0) {
            throw new IOException("handle is closed");
        }
    }
}

