/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import org.slf4j.Logger;
import sun.misc.Signal;

public class SignalHandler {
    private static boolean registered = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(Logger LOG) {
        Class<SignalHandler> clazz = SignalHandler.class;
        synchronized (SignalHandler.class) {
            if (registered) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            registered = true;
            String[] SIGNALS = new String[]{"TERM", "HUP", "INT"};
            StringBuilder bld = new StringBuilder();
            bld.append("Registered UNIX signal handlers for [");
            String separator = "";
            for (String signalName : SIGNALS) {
                try {
                    new Handler(signalName, LOG);
                    bld.append(separator);
                    bld.append(signalName);
                    separator = ", ";
                }
                catch (Exception e) {
                    LOG.info("Error while registering signal handler", (Throwable)e);
                }
            }
            bld.append("]");
            LOG.info(bld.toString());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static class Handler
    implements sun.misc.SignalHandler {
        private final Logger LOG;
        private final sun.misc.SignalHandler prevHandler;

        Handler(String name, Logger LOG) {
            this.LOG = LOG;
            this.prevHandler = Signal.handle(new Signal(name), this);
        }

        @Override
        public void handle(Signal signal) {
            this.LOG.info("RECEIVED SIGNAL {}: SIG{}. Shutting down as requested.", (Object)signal.getNumber(), (Object)signal.getName());
            this.prevHandler.handle(signal);
        }
    }
}

