/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.UUID;
import org.apache.flink.runtime.akka.FlinkUntypedActor;
import org.apache.flink.runtime.checkpoint.CheckpointCoordinator;
import org.apache.flink.runtime.checkpoint.SavepointCoordinator;
import org.apache.flink.runtime.jobgraph.JobStatus;
import org.apache.flink.runtime.messages.ExecutionGraphMessages;
import org.apache.flink.util.Preconditions;

public class SavepointCoordinatorDeActivator
extends FlinkUntypedActor {
    private final CheckpointCoordinator coordinator;
    private final UUID leaderSessionID;

    public SavepointCoordinatorDeActivator(SavepointCoordinator coordinator, UUID leaderSessionID) {
        this.LOG.info("Create SavepointCoordinatorDeActivator");
        this.coordinator = (CheckpointCoordinator)Preconditions.checkNotNull((Object)coordinator, (String)"The checkpointCoordinator must not be null.");
        this.leaderSessionID = leaderSessionID;
    }

    @Override
    public void handleMessage(Object message) throws Exception {
        JobStatus status;
        if (message instanceof ExecutionGraphMessages.JobStatusChanged && (status = ((ExecutionGraphMessages.JobStatusChanged)message).newJobStatus()) != JobStatus.RUNNING) {
            this.coordinator.stopCheckpointScheduler();
        }
    }

    @Override
    public UUID getLeaderSessionID() {
        return this.leaderSessionID;
    }
}

