/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.instance;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.instance.Instance;
import org.apache.flink.runtime.instance.SharedSlot;
import org.apache.flink.util.AbstractID;

public abstract class Slot {
    private static final AtomicIntegerFieldUpdater<Slot> STATUS_UPDATER = AtomicIntegerFieldUpdater.newUpdater(Slot.class, "status");
    private static final int ALLOCATED_AND_ALIVE = 0;
    private static final int CANCELLED = 1;
    private static final int RELEASED = 2;
    private final JobID jobID;
    private final AbstractID groupID;
    private final Instance instance;
    private final SharedSlot parent;
    private final int slotNumber;
    private volatile int status = 0;

    protected Slot(JobID jobID, Instance instance, int slotNumber, SharedSlot parent, AbstractID groupID) {
        if (jobID == null || instance == null || slotNumber < 0) {
            throw new IllegalArgumentException();
        }
        this.jobID = jobID;
        this.instance = instance;
        this.slotNumber = slotNumber;
        this.parent = parent;
        this.groupID = groupID;
    }

    public JobID getJobID() {
        return this.jobID;
    }

    public Instance getInstance() {
        return this.instance;
    }

    public int getSlotNumber() {
        return this.slotNumber;
    }

    public int getRootSlotNumber() {
        if (this.parent == null) {
            return this.slotNumber;
        }
        return this.parent.getRootSlotNumber();
    }

    public AbstractID getGroupID() {
        return this.groupID;
    }

    public SharedSlot getParent() {
        return this.parent;
    }

    public Slot getRoot() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getRoot();
    }

    public abstract int getNumberLeaves();

    public boolean isAlive() {
        return this.status == 0;
    }

    public boolean isCanceled() {
        return this.status != 0;
    }

    public boolean isReleased() {
        return this.status == 2;
    }

    final boolean markCancelled() {
        return STATUS_UPDATER.compareAndSet(this, 0, 1);
    }

    final boolean markReleased() {
        return STATUS_UPDATER.compareAndSet(this, 1, 2);
    }

    public abstract void releaseSlot();

    public String toString() {
        return this.hierarchy() + " - " + this.instance + " - " + Slot.getStateName(this.status);
    }

    protected String hierarchy() {
        return (this.getParent() != null ? this.getParent().hierarchy() : "") + "(" + this.slotNumber + ")";
    }

    private static String getStateName(int state) {
        switch (state) {
            case 0: {
                return "ALLOCATED/ALIVE";
            }
            case 1: {
                return "CANCELLED";
            }
            case 2: {
                return "RELEASED";
            }
        }
        return "(unknown)";
    }
}

