/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.api;

import java.io.IOException;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.event.RuntimeEvent;

public class CheckpointBarrier
extends RuntimeEvent {
    private long id;
    private long timestamp;

    public CheckpointBarrier() {
    }

    public CheckpointBarrier(long id, long timestamp) {
        this.id = id;
        this.timestamp = timestamp;
    }

    public long getId() {
        return this.id;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void write(DataOutputView out) throws IOException {
        out.writeLong(this.id);
        out.writeLong(this.timestamp);
    }

    public void read(DataInputView in) throws IOException {
        this.id = in.readLong();
        this.timestamp = in.readLong();
    }

    public int hashCode() {
        return (int)(this.id ^ this.id >>> 32 ^ this.timestamp ^ this.timestamp >>> 32);
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof CheckpointBarrier)) {
            return false;
        }
        CheckpointBarrier that = (CheckpointBarrier)other;
        return that.id == this.id && that.timestamp == this.timestamp;
    }

    public String toString() {
        return String.format("CheckpointBarrier %d @ %d", this.id, this.timestamp);
    }
}

