/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.api.serialization;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.groups.IOMetricGroup;
import org.apache.flink.runtime.accumulators.AccumulatorRegistry;
import org.apache.flink.runtime.io.network.api.serialization.RecordSerializer;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.util.DataOutputSerializer;

public class SpanningRecordSerializer<T extends IOReadableWritable>
implements RecordSerializer<T> {
    private static final boolean CHECKED = false;
    private final DataOutputSerializer serializationBuffer = new DataOutputSerializer(128);
    private ByteBuffer dataBuffer;
    private final ByteBuffer lengthBuffer = ByteBuffer.allocate(4);
    private Buffer targetBuffer;
    private int position;
    private int limit;
    private AccumulatorRegistry.Reporter reporter;
    private transient Counter numBytesOut;

    public SpanningRecordSerializer() {
        this.lengthBuffer.order(ByteOrder.BIG_ENDIAN);
        this.dataBuffer = this.serializationBuffer.wrapAsByteBuffer();
        this.lengthBuffer.position(4);
    }

    @Override
    public RecordSerializer.SerializationResult addRecord(T record) throws IOException {
        this.serializationBuffer.clear();
        this.lengthBuffer.clear();
        record.write((DataOutputView)this.serializationBuffer);
        int len = this.serializationBuffer.length();
        this.lengthBuffer.putInt(0, len);
        if (this.reporter != null) {
            this.reporter.reportNumBytesOut(len);
            this.reporter.reportNumRecordsOut(1L);
        }
        if (this.numBytesOut != null) {
            this.numBytesOut.inc((long)len);
        }
        this.dataBuffer = this.serializationBuffer.wrapAsByteBuffer();
        this.copyToTargetBufferFrom(this.lengthBuffer);
        this.copyToTargetBufferFrom(this.dataBuffer);
        return this.getSerializationResult();
    }

    @Override
    public RecordSerializer.SerializationResult setNextBuffer(Buffer buffer) throws IOException {
        RecordSerializer.SerializationResult result;
        this.targetBuffer = buffer;
        this.position = 0;
        this.limit = buffer.getSize();
        if (this.lengthBuffer.hasRemaining()) {
            this.copyToTargetBufferFrom(this.lengthBuffer);
        }
        if (this.dataBuffer.hasRemaining()) {
            this.copyToTargetBufferFrom(this.dataBuffer);
        }
        if ((result = this.getSerializationResult()).isFullRecord()) {
            this.serializationBuffer.clear();
            this.serializationBuffer.pruneBuffer();
            this.dataBuffer = this.serializationBuffer.wrapAsByteBuffer();
        }
        return result;
    }

    private void copyToTargetBufferFrom(ByteBuffer source) {
        if (this.targetBuffer == null) {
            return;
        }
        int needed = source.remaining();
        int available = this.limit - this.position;
        int toCopy = Math.min(needed, available);
        this.targetBuffer.getMemorySegment().put(this.position, source, toCopy);
        this.position += toCopy;
    }

    private RecordSerializer.SerializationResult getSerializationResult() {
        if (!this.dataBuffer.hasRemaining() && !this.lengthBuffer.hasRemaining()) {
            return this.position < this.limit ? RecordSerializer.SerializationResult.FULL_RECORD : RecordSerializer.SerializationResult.FULL_RECORD_MEMORY_SEGMENT_FULL;
        }
        return RecordSerializer.SerializationResult.PARTIAL_RECORD_MEMORY_SEGMENT_FULL;
    }

    @Override
    public Buffer getCurrentBuffer() {
        if (this.targetBuffer == null) {
            return null;
        }
        this.targetBuffer.setSize(this.position);
        return this.targetBuffer;
    }

    @Override
    public void clearCurrentBuffer() {
        this.targetBuffer = null;
    }

    @Override
    public void clear() {
        this.targetBuffer = null;
        this.position = 0;
        this.limit = 0;
        this.dataBuffer.position(this.dataBuffer.limit());
        this.lengthBuffer.position(4);
    }

    @Override
    public boolean hasData() {
        return this.position > 0 || this.lengthBuffer.hasRemaining() || this.dataBuffer.hasRemaining();
    }

    @Override
    public void setReporter(AccumulatorRegistry.Reporter reporter) {
        this.reporter = reporter;
    }

    @Override
    public void instantiateMetrics(IOMetricGroup metrics) {
        this.numBytesOut = metrics.getBytesOutCounter();
    }
}

