/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.netty;

import io.netty.channel.ChannelHandler;
import org.apache.flink.runtime.io.network.TaskEventDispatcher;
import org.apache.flink.runtime.io.network.buffer.NetworkBufferPool;
import org.apache.flink.runtime.io.network.netty.NettyMessage;
import org.apache.flink.runtime.io.network.netty.NettyProtocol;
import org.apache.flink.runtime.io.network.netty.PartitionRequestClientHandler;
import org.apache.flink.runtime.io.network.netty.PartitionRequestQueue;
import org.apache.flink.runtime.io.network.netty.PartitionRequestServerHandler;
import org.apache.flink.runtime.io.network.partition.ResultPartitionProvider;

class PartitionRequestProtocol
implements NettyProtocol {
    private final NettyMessage.NettyMessageEncoder messageEncoder = new NettyMessage.NettyMessageEncoder();
    private final NettyMessage.NettyMessageDecoder messageDecoder = new NettyMessage.NettyMessageDecoder();
    private final ResultPartitionProvider partitionProvider;
    private final TaskEventDispatcher taskEventDispatcher;
    private final NetworkBufferPool networkbufferPool;

    PartitionRequestProtocol(ResultPartitionProvider partitionProvider, TaskEventDispatcher taskEventDispatcher, NetworkBufferPool networkbufferPool) {
        this.partitionProvider = partitionProvider;
        this.taskEventDispatcher = taskEventDispatcher;
        this.networkbufferPool = networkbufferPool;
    }

    @Override
    public ChannelHandler[] getServerChannelHandlers() {
        PartitionRequestQueue queueOfPartitionQueues = new PartitionRequestQueue();
        PartitionRequestServerHandler serverHandler = new PartitionRequestServerHandler(this.partitionProvider, this.taskEventDispatcher, queueOfPartitionQueues, this.networkbufferPool);
        return new ChannelHandler[]{this.messageEncoder, NettyMessage.NettyMessageEncoder.createFrameLengthDecoder(), this.messageDecoder, serverHandler, queueOfPartitionQueues};
    }

    @Override
    public ChannelHandler[] getClientChannelHandlers() {
        return new ChannelHandler[]{this.messageEncoder, NettyMessage.NettyMessageEncoder.createFrameLengthDecoder(), this.messageDecoder, new PartitionRequestClientHandler()};
    }
}

