/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.consumer;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.flink.metrics.Counter;
import org.apache.flink.runtime.event.TaskEvent;
import org.apache.flink.runtime.execution.CancelTaskException;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.consumer.SingleInputGate;
import org.apache.flink.util.Preconditions;
import scala.Tuple2;

public abstract class InputChannel {
    protected final int channelIndex;
    protected final ResultPartitionID partitionId;
    protected final SingleInputGate inputGate;
    private final AtomicReference<Throwable> cause = new AtomicReference();
    private final int initialBackoff;
    private final int maxBackoff;
    protected final Counter numBytesIn;
    private int currentBackoff;

    protected InputChannel(SingleInputGate inputGate, int channelIndex, ResultPartitionID partitionId, Tuple2<Integer, Integer> initialAndMaxBackoff, Counter numBytesIn) {
        Preconditions.checkArgument((channelIndex >= 0 ? 1 : 0) != 0);
        int initial = (Integer)initialAndMaxBackoff._1();
        int max = (Integer)initialAndMaxBackoff._2();
        Preconditions.checkArgument((initial >= 0 && initial <= max ? 1 : 0) != 0);
        this.inputGate = (SingleInputGate)Preconditions.checkNotNull((Object)inputGate);
        this.channelIndex = channelIndex;
        this.partitionId = (ResultPartitionID)Preconditions.checkNotNull((Object)partitionId);
        this.initialBackoff = initial;
        this.maxBackoff = max;
        this.currentBackoff = initial == 0 ? -1 : 0;
        this.numBytesIn = numBytesIn;
    }

    int getChannelIndex() {
        return this.channelIndex;
    }

    protected void notifyAvailableBuffer() {
        this.inputGate.onAvailableBuffer(this);
    }

    abstract void requestSubpartition(int var1) throws IOException, InterruptedException;

    abstract Buffer getNextBuffer() throws IOException, InterruptedException;

    abstract void sendTaskEvent(TaskEvent var1) throws IOException;

    abstract boolean isReleased();

    abstract void notifySubpartitionConsumed() throws IOException;

    abstract void releaseAllResources() throws IOException;

    protected void checkError() throws IOException {
        Throwable t = this.cause.get();
        if (t != null) {
            if (t instanceof CancelTaskException) {
                throw (CancelTaskException)t;
            }
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw new IOException(t);
        }
    }

    protected void setError(Throwable cause) {
        if (this.cause.compareAndSet(null, (Throwable)Preconditions.checkNotNull((Object)cause))) {
            this.notifyAvailableBuffer();
        }
    }

    protected int getCurrentBackoff() {
        return this.currentBackoff <= 0 ? 0 : this.currentBackoff;
    }

    protected boolean increaseBackoff() {
        if (this.currentBackoff < 0) {
            return false;
        }
        if (this.currentBackoff == 0) {
            this.currentBackoff = this.initialBackoff;
            return true;
        }
        if (this.currentBackoff < this.maxBackoff) {
            this.currentBackoff = Math.min(this.currentBackoff * 2, this.maxBackoff);
            return true;
        }
        return false;
    }
}

