/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.messages.webmonitor;

import org.apache.flink.runtime.messages.webmonitor.InfoMessage;

public class JobsOverview
implements InfoMessage {
    private static final long serialVersionUID = -3699051943490133183L;
    private final int numJobsRunningOrPending;
    private final int numJobsFinished;
    private final int numJobsCancelled;
    private final int numJobsFailed;

    public JobsOverview(int numJobsRunningOrPending, int numJobsFinished, int numJobsCancelled, int numJobsFailed) {
        this.numJobsRunningOrPending = numJobsRunningOrPending;
        this.numJobsFinished = numJobsFinished;
        this.numJobsCancelled = numJobsCancelled;
        this.numJobsFailed = numJobsFailed;
    }

    public JobsOverview(JobsOverview first, JobsOverview second) {
        this.numJobsRunningOrPending = first.numJobsRunningOrPending + second.numJobsRunningOrPending;
        this.numJobsFinished = first.numJobsFinished + second.numJobsFinished;
        this.numJobsCancelled = first.numJobsCancelled + second.numJobsCancelled;
        this.numJobsFailed = first.numJobsFailed + second.numJobsFailed;
    }

    public int getNumJobsRunningOrPending() {
        return this.numJobsRunningOrPending;
    }

    public int getNumJobsFinished() {
        return this.numJobsFinished;
    }

    public int getNumJobsCancelled() {
        return this.numJobsCancelled;
    }

    public int getNumJobsFailed() {
        return this.numJobsFailed;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof JobsOverview) {
            JobsOverview that = (JobsOverview)obj;
            return this.numJobsRunningOrPending == that.numJobsRunningOrPending && this.numJobsFinished == that.numJobsFinished && this.numJobsCancelled == that.numJobsCancelled && this.numJobsFailed == that.numJobsFailed;
        }
        return false;
    }

    public int hashCode() {
        int result = this.numJobsRunningOrPending;
        result = 31 * result + this.numJobsFinished;
        result = 31 * result + this.numJobsCancelled;
        result = 31 * result + this.numJobsFailed;
        return result;
    }

    public String toString() {
        return "JobsOverview {numJobsRunningOrPending=" + this.numJobsRunningOrPending + ", numJobsFinished=" + this.numJobsFinished + ", numJobsCancelled=" + this.numJobsCancelled + ", numJobsFailed=" + this.numJobsFailed + '}';
    }
}

