/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.shipping;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.io.network.api.writer.RecordWriter;
import org.apache.flink.runtime.plugable.SerializationDelegate;
import org.apache.flink.util.Collector;

public class OutputCollector<T>
implements Collector<T> {
    private final RecordWriter<SerializationDelegate<T>>[] writers;
    private final SerializationDelegate<T> delegate;

    public OutputCollector(List<RecordWriter<SerializationDelegate<T>>> writers, TypeSerializer<T> serializer) {
        this.delegate = new SerializationDelegate<T>(serializer);
        this.writers = writers.toArray(new RecordWriter[writers.size()]);
    }

    public void collect(T record) {
        if (record != null) {
            this.delegate.setInstance(record);
            try {
                for (RecordWriter<SerializationDelegate<SerializationDelegate<T>>> recordWriter : this.writers) {
                    recordWriter.emit(this.delegate);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Emitting the record caused an I/O exception: " + e.getMessage(), e);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Emitting the record was interrupted: " + e.getMessage(), e);
            }
        } else {
            throw new NullPointerException("The system does not support records that are null.Null values are only supported as fields inside other objects.");
        }
    }

    public void close() {
        for (RecordWriter<SerializationDelegate<T>> writer : this.writers) {
            try {
                writer.flush();
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    public List<RecordWriter<SerializationDelegate<T>>> getWriters() {
        return Collections.unmodifiableList(Arrays.asList(this.writers));
    }
}

