/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.process;

import akka.actor.ActorRef;
import akka.actor.Terminated;
import akka.actor.UntypedActor;
import org.slf4j.Logger;

public class ProcessReaper
extends UntypedActor {
    private final Logger log;
    private final int exitCode;

    public ProcessReaper(ActorRef watchTarget, Logger log, int exitCode) {
        if (watchTarget == null || watchTarget.equals((Object)ActorRef.noSender())) {
            throw new IllegalArgumentException("Target may not be null or 'noSender'");
        }
        this.log = log;
        this.exitCode = exitCode;
        this.getContext().watch(watchTarget);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onReceive(Object message) {
        if (message instanceof Terminated) {
            try {
                Terminated term = (Terminated)message;
                String name = term.actor().path().toSerializationFormat();
                if (this.log != null) {
                    this.log.error("Actor " + name + " terminated, stopping process...");
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            finally {
                System.exit(this.exitCode);
            }
        }
    }
}

