/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.filesystem;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.ArrayListSerializer;
import org.apache.flink.runtime.state.KvState;
import org.apache.flink.runtime.state.KvStateSnapshot;
import org.apache.flink.runtime.state.filesystem.AbstractFsState;
import org.apache.flink.runtime.state.filesystem.AbstractFsStateSnapshot;
import org.apache.flink.runtime.state.filesystem.FsStateBackend;

public class FsListState<K, N, V>
extends AbstractFsState<K, N, ArrayList<V>, ListState<V>, ListStateDescriptor<V>>
implements ListState<V> {
    public FsListState(FsStateBackend backend, TypeSerializer<K> keySerializer, TypeSerializer<N> namespaceSerializer, ListStateDescriptor<V> stateDesc) {
        super(backend, keySerializer, namespaceSerializer, new ArrayListSerializer(stateDesc.getSerializer()), stateDesc);
    }

    public FsListState(FsStateBackend backend, TypeSerializer<K> keySerializer, TypeSerializer<N> namespaceSerializer, ListStateDescriptor<V> stateDesc, HashMap<N, Map<K, ArrayList<V>>> state) {
        super(backend, keySerializer, namespaceSerializer, new ArrayListSerializer(stateDesc.getSerializer()), stateDesc, state);
    }

    public Iterable<V> get() {
        if (this.currentNSState == null) {
            this.currentNSState = (Map)this.state.get(this.currentNamespace);
        }
        if (this.currentNSState != null) {
            List result = (List)this.currentNSState.get(this.currentKey);
            if (result == null) {
                return Collections.emptyList();
            }
            return result;
        }
        return Collections.emptyList();
    }

    public void add(V value) {
        ArrayList<V> list;
        if (this.currentKey == null) {
            throw new RuntimeException("No key available.");
        }
        if (this.currentNSState == null) {
            this.currentNSState = new HashMap();
            this.state.put(this.currentNamespace, this.currentNSState);
        }
        if ((list = (ArrayList<V>)this.currentNSState.get(this.currentKey)) == null) {
            list = new ArrayList<V>();
            this.currentNSState.put(this.currentKey, list);
        }
        list.add(value);
    }

    @Override
    public KvStateSnapshot<K, N, ListState<V>, ListStateDescriptor<V>, FsStateBackend> createHeapSnapshot(Path filePath) {
        return new Snapshot(this.getKeySerializer(), this.getNamespaceSerializer(), new ArrayListSerializer(((ListStateDescriptor)this.stateDesc).getSerializer()), (ListStateDescriptor)this.stateDesc, filePath);
    }

    public static class Snapshot<K, N, V>
    extends AbstractFsStateSnapshot<K, N, ArrayList<V>, ListState<V>, ListStateDescriptor<V>> {
        private static final long serialVersionUID = 1L;

        public Snapshot(TypeSerializer<K> keySerializer, TypeSerializer<N> namespaceSerializer, TypeSerializer<ArrayList<V>> stateSerializer, ListStateDescriptor<V> stateDescs, Path filePath) {
            super(keySerializer, namespaceSerializer, stateSerializer, stateDescs, filePath);
        }

        @Override
        public KvState<K, N, ListState<V>, ListStateDescriptor<V>, FsStateBackend> createFsState(FsStateBackend backend, HashMap<N, Map<K, ArrayList<V>>> stateMap) {
            return new FsListState<K, N, V>(backend, this.keySerializer, this.namespaceSerializer, (ListStateDescriptor)this.stateDesc, stateMap);
        }
    }
}

