/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.memory;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.KvState;
import org.apache.flink.runtime.state.KvStateSnapshot;
import org.apache.flink.runtime.state.memory.AbstractMemState;
import org.apache.flink.runtime.state.memory.AbstractMemStateSnapshot;
import org.apache.flink.runtime.state.memory.MemoryStateBackend;

public class MemValueState<K, N, V>
extends AbstractMemState<K, N, V, ValueState<V>, ValueStateDescriptor<V>>
implements ValueState<V> {
    public MemValueState(TypeSerializer<K> keySerializer, TypeSerializer<N> namespaceSerializer, ValueStateDescriptor<V> stateDesc) {
        super(keySerializer, namespaceSerializer, stateDesc.getSerializer(), stateDesc);
    }

    public MemValueState(TypeSerializer<K> keySerializer, TypeSerializer<N> namespaceSerializer, ValueStateDescriptor<V> stateDesc, HashMap<N, Map<K, V>> state) {
        super(keySerializer, namespaceSerializer, stateDesc.getSerializer(), stateDesc, state);
    }

    public V value() {
        if (this.currentNSState == null) {
            this.currentNSState = (Map)this.state.get(this.currentNamespace);
        }
        if (this.currentNSState != null) {
            Object value = this.currentNSState.get(this.currentKey);
            return (V)(value != null ? value : ((ValueStateDescriptor)this.stateDesc).getDefaultValue());
        }
        return (V)((ValueStateDescriptor)this.stateDesc).getDefaultValue();
    }

    public void update(V value) {
        if (this.currentKey == null) {
            throw new RuntimeException("No key available.");
        }
        if (value == null) {
            this.clear();
            return;
        }
        if (this.currentNSState == null) {
            this.currentNSState = new HashMap();
            this.state.put(this.currentNamespace, this.currentNSState);
        }
        this.currentNSState.put(this.currentKey, value);
    }

    @Override
    public KvStateSnapshot<K, N, ValueState<V>, ValueStateDescriptor<V>, MemoryStateBackend> createHeapSnapshot(byte[] bytes) {
        return new Snapshot(this.getKeySerializer(), this.getNamespaceSerializer(), this.stateSerializer, (ValueStateDescriptor)this.stateDesc, bytes);
    }

    public static class Snapshot<K, N, V>
    extends AbstractMemStateSnapshot<K, N, V, ValueState<V>, ValueStateDescriptor<V>> {
        private static final long serialVersionUID = 1L;

        public Snapshot(TypeSerializer<K> keySerializer, TypeSerializer<N> namespaceSerializer, TypeSerializer<V> stateSerializer, ValueStateDescriptor<V> stateDescs, byte[] data) {
            super(keySerializer, namespaceSerializer, stateSerializer, stateDescs, data);
        }

        @Override
        public KvState<K, N, ValueState<V>, ValueStateDescriptor<V>, MemoryStateBackend> createMemState(HashMap<N, Map<K, V>> stateMap) {
            return new MemValueState<K, N, V>(this.keySerializer, this.namespaceSerializer, (ValueStateDescriptor)this.stateDesc, stateMap);
        }
    }
}

