/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.shaded.jackson2.com.fasterxml.jackson.dataformat.csv.impl;

import java.io.IOException;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.dataformat.csv.impl.CsvEncoder;

public abstract class BufferedValue {
    protected BufferedValue() {
    }

    public abstract void write(CsvEncoder var1) throws IOException;

    public static BufferedValue buffered(String v) {
        return new TextValue(v);
    }

    public static BufferedValue bufferedRaw(String v) {
        return new RawValue(v);
    }

    public static BufferedValue buffered(int v) {
        return new IntValue(v);
    }

    public static BufferedValue buffered(long v) {
        return new LongValue(v);
    }

    public static BufferedValue buffered(float v) {
        return new FloatValue(v);
    }

    public static BufferedValue buffered(double v) {
        return new DoubleValue(v);
    }

    public static BufferedValue bufferedNumber(String numStr) {
        return new BigNumberValue(numStr);
    }

    public static BufferedValue buffered(boolean v) {
        return v ? BooleanValue.TRUE : BooleanValue.FALSE;
    }

    public static BufferedValue bufferedNull() {
        return NullValue.std;
    }

    protected static final class NullValue
    extends BufferedValue {
        public static final NullValue std = new NullValue();

        private NullValue() {
        }

        @Override
        public void write(CsvEncoder w) throws IOException {
            w.appendNull();
        }
    }

    protected static final class BooleanValue
    extends BufferedValue {
        public static final BooleanValue FALSE = new BooleanValue(false);
        public static final BooleanValue TRUE = new BooleanValue(true);
        private final boolean _value;

        public BooleanValue(boolean v) {
            this._value = v;
        }

        @Override
        public void write(CsvEncoder w) throws IOException {
            w.appendValue(this._value);
        }
    }

    protected static final class BigNumberValue
    extends BufferedValue {
        private final String _value;

        public BigNumberValue(String v) {
            this._value = v;
        }

        @Override
        public void write(CsvEncoder w) throws IOException {
            w.appendNumberValue(this._value);
        }
    }

    protected static final class DoubleValue
    extends BufferedValue {
        private final double _value;

        public DoubleValue(double v) {
            this._value = v;
        }

        @Override
        public void write(CsvEncoder w) throws IOException {
            w.appendValue(this._value);
        }
    }

    protected static final class FloatValue
    extends BufferedValue {
        private final float _value;

        public FloatValue(float v) {
            this._value = v;
        }

        @Override
        public void write(CsvEncoder w) throws IOException {
            w.appendValue(this._value);
        }
    }

    protected static final class LongValue
    extends BufferedValue {
        private final long _value;

        public LongValue(long v) {
            this._value = v;
        }

        @Override
        public void write(CsvEncoder w) throws IOException {
            w.appendValue(this._value);
        }
    }

    protected static final class IntValue
    extends BufferedValue {
        private final int _value;

        public IntValue(int v) {
            this._value = v;
        }

        @Override
        public void write(CsvEncoder w) throws IOException {
            w.appendValue(this._value);
        }
    }

    protected static final class RawValue
    extends BufferedValue {
        private final String _value;

        public RawValue(String v) {
            this._value = v;
        }

        @Override
        public void write(CsvEncoder w) throws IOException {
            w.appendRawValue(this._value);
        }
    }

    protected static final class TextValue
    extends BufferedValue {
        private final String _value;

        public TextValue(String v) {
            this._value = v;
        }

        @Override
        public void write(CsvEncoder w) throws IOException {
            w.appendValue(this._value);
        }
    }
}

