/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.rocksdb;

import java.nio.file.Path;
import org.apache.flink.runtime.state.DirectoryStateHandle;
import org.apache.flink.runtime.state.IncrementalLocalKeyedStateHandle;
import org.apache.flink.runtime.state.IncrementalRemoteKeyedStateHandle;

public class StateHandleDownloadSpec {
    private final IncrementalRemoteKeyedStateHandle stateHandle;
    private final Path downloadDestination;

    public StateHandleDownloadSpec(IncrementalRemoteKeyedStateHandle stateHandle, Path downloadDestination) {
        this.stateHandle = stateHandle;
        this.downloadDestination = downloadDestination;
    }

    public IncrementalRemoteKeyedStateHandle getStateHandle() {
        return this.stateHandle;
    }

    public Path getDownloadDestination() {
        return this.downloadDestination;
    }

    public IncrementalLocalKeyedStateHandle createLocalStateHandleForDownloadedState() {
        return new IncrementalLocalKeyedStateHandle(this.stateHandle.getBackendIdentifier(), this.stateHandle.getCheckpointId(), new DirectoryStateHandle(this.downloadDestination, this.stateHandle.getStateSize()), this.stateHandle.getKeyGroupRange(), this.stateHandle.getMetaDataStateHandle(), this.stateHandle.getSharedState());
    }

    public String toString() {
        return "StateHandleDownloadSpec(downloadDestination = [" + this.downloadDestination + "] stateHandle = [" + this.stateHandle + "])";
    }
}

