/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.windowing;

import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.shaded.guava31.com.google.common.collect.Lists;
import org.apache.flink.streaming.api.windowing.triggers.ProcessingTimeTrigger;
import org.apache.flink.streaming.api.windowing.triggers.TriggerResult;
import org.apache.flink.streaming.api.windowing.windows.TimeWindow;
import org.apache.flink.streaming.runtime.operators.windowing.TriggerTestHarness;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.junit.Assert;
import org.junit.Test;

public class ProcessingTimeTriggerTest {
    @Test
    public void testWindowSeparationAndFiring() throws Exception {
        TriggerTestHarness testHarness = new TriggerTestHarness(ProcessingTimeTrigger.create(), (TypeSerializer<TimeWindow>)new TimeWindow.Serializer());
        Assert.assertEquals((Object)TriggerResult.CONTINUE, (Object)testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(0L, 2L)));
        Assert.assertEquals((Object)TriggerResult.CONTINUE, (Object)testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(0L, 2L)));
        Assert.assertEquals((Object)TriggerResult.CONTINUE, (Object)testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(0L, 2L)));
        Assert.assertEquals((Object)TriggerResult.CONTINUE, (Object)testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(2L, 4L)));
        Assert.assertEquals((Object)TriggerResult.CONTINUE, (Object)testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(2L, 4L)));
        Assert.assertEquals((long)0L, (long)testHarness.numStateEntries());
        Assert.assertEquals((long)0L, (long)testHarness.numEventTimeTimers());
        Assert.assertEquals((long)2L, (long)testHarness.numProcessingTimeTimers());
        Assert.assertEquals((long)1L, (long)testHarness.numProcessingTimeTimers(new TimeWindow(0L, 2L)));
        Assert.assertEquals((long)1L, (long)testHarness.numProcessingTimeTimers(new TimeWindow(2L, 4L)));
        Assert.assertEquals((Object)TriggerResult.FIRE, (Object)testHarness.advanceProcessingTime(2L, new TimeWindow(0L, 2L)));
        Assert.assertEquals((long)0L, (long)testHarness.numStateEntries());
        Assert.assertEquals((long)0L, (long)testHarness.numEventTimeTimers());
        Assert.assertEquals((long)1L, (long)testHarness.numProcessingTimeTimers());
        Assert.assertEquals((long)0L, (long)testHarness.numProcessingTimeTimers(new TimeWindow(0L, 2L)));
        Assert.assertEquals((long)1L, (long)testHarness.numProcessingTimeTimers(new TimeWindow(2L, 4L)));
        Assert.assertEquals((Object)TriggerResult.FIRE, (Object)testHarness.advanceProcessingTime(4L, new TimeWindow(2L, 4L)));
        Assert.assertEquals((long)0L, (long)testHarness.numStateEntries());
        Assert.assertEquals((long)0L, (long)testHarness.numProcessingTimeTimers());
        Assert.assertEquals((long)0L, (long)testHarness.numEventTimeTimers());
    }

    @Test
    public void testClear() throws Exception {
        TriggerTestHarness testHarness = new TriggerTestHarness(ProcessingTimeTrigger.create(), (TypeSerializer<TimeWindow>)new TimeWindow.Serializer());
        Assert.assertEquals((Object)TriggerResult.CONTINUE, (Object)testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(0L, 2L)));
        Assert.assertEquals((Object)TriggerResult.CONTINUE, (Object)testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(2L, 4L)));
        Assert.assertEquals((long)0L, (long)testHarness.numStateEntries());
        Assert.assertEquals((long)0L, (long)testHarness.numEventTimeTimers());
        Assert.assertEquals((long)2L, (long)testHarness.numProcessingTimeTimers());
        Assert.assertEquals((long)1L, (long)testHarness.numProcessingTimeTimers(new TimeWindow(0L, 2L)));
        Assert.assertEquals((long)1L, (long)testHarness.numProcessingTimeTimers(new TimeWindow(2L, 4L)));
        testHarness.clearTriggerState(new TimeWindow(2L, 4L));
        Assert.assertEquals((long)0L, (long)testHarness.numStateEntries());
        Assert.assertEquals((long)0L, (long)testHarness.numEventTimeTimers());
        Assert.assertEquals((long)1L, (long)testHarness.numProcessingTimeTimers());
        Assert.assertEquals((long)1L, (long)testHarness.numProcessingTimeTimers(new TimeWindow(0L, 2L)));
        Assert.assertEquals((long)0L, (long)testHarness.numProcessingTimeTimers(new TimeWindow(2L, 4L)));
        testHarness.clearTriggerState(new TimeWindow(0L, 2L));
        Assert.assertEquals((long)0L, (long)testHarness.numStateEntries());
        Assert.assertEquals((long)0L, (long)testHarness.numProcessingTimeTimers());
        Assert.assertEquals((long)0L, (long)testHarness.numProcessingTimeTimers());
    }

    @Test
    public void testMergingWindows() throws Exception {
        TriggerTestHarness testHarness = new TriggerTestHarness(ProcessingTimeTrigger.create(), (TypeSerializer<TimeWindow>)new TimeWindow.Serializer());
        Assert.assertTrue((boolean)ProcessingTimeTrigger.create().canMerge());
        Assert.assertEquals((Object)TriggerResult.CONTINUE, (Object)testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(0L, 2L)));
        Assert.assertEquals((Object)TriggerResult.CONTINUE, (Object)testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(2L, 4L)));
        Assert.assertEquals((long)0L, (long)testHarness.numStateEntries());
        Assert.assertEquals((long)0L, (long)testHarness.numEventTimeTimers());
        Assert.assertEquals((long)2L, (long)testHarness.numProcessingTimeTimers());
        Assert.assertEquals((long)1L, (long)testHarness.numProcessingTimeTimers(new TimeWindow(0L, 2L)));
        Assert.assertEquals((long)1L, (long)testHarness.numProcessingTimeTimers(new TimeWindow(2L, 4L)));
        testHarness.mergeWindows(new TimeWindow(0L, 4L), Lists.newArrayList((Object[])new TimeWindow[]{new TimeWindow(0L, 2L), new TimeWindow(2L, 4L)}));
        Assert.assertEquals((long)0L, (long)testHarness.numStateEntries());
        Assert.assertEquals((long)0L, (long)testHarness.numEventTimeTimers());
        Assert.assertEquals((long)1L, (long)testHarness.numProcessingTimeTimers());
        Assert.assertEquals((long)0L, (long)testHarness.numProcessingTimeTimers(new TimeWindow(0L, 2L)));
        Assert.assertEquals((long)0L, (long)testHarness.numProcessingTimeTimers(new TimeWindow(2L, 4L)));
        Assert.assertEquals((long)1L, (long)testHarness.numProcessingTimeTimers(new TimeWindow(0L, 4L)));
        Assert.assertEquals((Object)TriggerResult.FIRE, (Object)testHarness.advanceProcessingTime(4L, new TimeWindow(0L, 4L)));
        Assert.assertEquals((long)0L, (long)testHarness.numStateEntries());
        Assert.assertEquals((long)0L, (long)testHarness.numProcessingTimeTimers());
        Assert.assertEquals((long)0L, (long)testHarness.numEventTimeTimers());
    }

    @Test
    public void testMergingLateWindows() throws Exception {
        TriggerTestHarness testHarness = new TriggerTestHarness(ProcessingTimeTrigger.create(), (TypeSerializer<TimeWindow>)new TimeWindow.Serializer());
        Assert.assertTrue((boolean)ProcessingTimeTrigger.create().canMerge());
        Assert.assertEquals((Object)TriggerResult.CONTINUE, (Object)testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(0L, 2L)));
        Assert.assertEquals((Object)TriggerResult.CONTINUE, (Object)testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(2L, 4L)));
        Assert.assertEquals((long)0L, (long)testHarness.numStateEntries());
        Assert.assertEquals((long)0L, (long)testHarness.numEventTimeTimers());
        Assert.assertEquals((long)2L, (long)testHarness.numProcessingTimeTimers());
        Assert.assertEquals((long)1L, (long)testHarness.numProcessingTimeTimers(new TimeWindow(0L, 2L)));
        Assert.assertEquals((long)1L, (long)testHarness.numProcessingTimeTimers(new TimeWindow(2L, 4L)));
        testHarness.advanceProcessingTime(10L);
        Assert.assertEquals((long)0L, (long)testHarness.numStateEntries());
        Assert.assertEquals((long)0L, (long)testHarness.numEventTimeTimers());
        Assert.assertEquals((long)0L, (long)testHarness.numProcessingTimeTimers());
        Assert.assertEquals((long)0L, (long)testHarness.numProcessingTimeTimers(new TimeWindow(0L, 2L)));
        Assert.assertEquals((long)0L, (long)testHarness.numProcessingTimeTimers(new TimeWindow(2L, 4L)));
        testHarness.mergeWindows(new TimeWindow(0L, 4L), Lists.newArrayList((Object[])new TimeWindow[]{new TimeWindow(0L, 2L), new TimeWindow(2L, 4L)}));
        Assert.assertEquals((long)0L, (long)testHarness.numStateEntries());
        Assert.assertEquals((long)0L, (long)testHarness.numEventTimeTimers());
        Assert.assertEquals((long)0L, (long)testHarness.numProcessingTimeTimers());
        Assert.assertEquals((long)0L, (long)testHarness.numProcessingTimeTimers(new TimeWindow(0L, 2L)));
        Assert.assertEquals((long)0L, (long)testHarness.numProcessingTimeTimers(new TimeWindow(2L, 4L)));
        Assert.assertEquals((long)0L, (long)testHarness.numProcessingTimeTimers(new TimeWindow(0L, 4L)));
    }
}

