/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util.keys;

import org.apache.flink.api.common.typeinfo.BasicArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.PrimitiveArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.tuple.Tuple1;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.streaming.util.keys.KeySelectorUtil;
import org.junit.Assert;
import org.junit.Test;

public class ArrayKeySelectorTest {
    @Test
    public void testObjectArrays() {
        try {
            String[] array1 = new String[]{"a", "b", "c", "d", "e"};
            String[] array2 = new String[]{"v", "w", "x", "y", "z"};
            KeySelectorUtil.ArrayKeySelector singleFieldSelector = KeySelectorUtil.getSelectorForArray((int[])new int[]{1}, (TypeInformation)BasicArrayTypeInfo.STRING_ARRAY_TYPE_INFO);
            Assert.assertEquals((Object)new Tuple1((Object)"b"), (Object)singleFieldSelector.getKey((Object)array1));
            Assert.assertEquals((Object)new Tuple1((Object)"w"), (Object)singleFieldSelector.getKey((Object)array2));
            KeySelectorUtil.ArrayKeySelector twoFieldsSelector = KeySelectorUtil.getSelectorForArray((int[])new int[]{3, 0}, (TypeInformation)BasicArrayTypeInfo.STRING_ARRAY_TYPE_INFO);
            Assert.assertEquals((Object)new Tuple2((Object)"d", (Object)"a"), (Object)twoFieldsSelector.getKey((Object)array1));
            Assert.assertEquals((Object)new Tuple2((Object)"y", (Object)"v"), (Object)twoFieldsSelector.getKey((Object)array2));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testPrimitiveArrays() {
        try {
            int[] array1 = new int[]{1, 2, 3, 4, 5};
            int[] array2 = new int[]{-5, -4, -3, -2, -1, 0};
            KeySelectorUtil.ArrayKeySelector singleFieldSelector = KeySelectorUtil.getSelectorForArray((int[])new int[]{1}, (TypeInformation)PrimitiveArrayTypeInfo.INT_PRIMITIVE_ARRAY_TYPE_INFO);
            Assert.assertEquals((Object)new Tuple1((Object)2), (Object)singleFieldSelector.getKey((Object)array1));
            Assert.assertEquals((Object)new Tuple1((Object)-4), (Object)singleFieldSelector.getKey((Object)array2));
            KeySelectorUtil.ArrayKeySelector twoFieldsSelector = KeySelectorUtil.getSelectorForArray((int[])new int[]{3, 0}, (TypeInformation)PrimitiveArrayTypeInfo.INT_PRIMITIVE_ARRAY_TYPE_INFO);
            Assert.assertEquals((Object)new Tuple2((Object)4, (Object)1), (Object)twoFieldsSelector.getKey((Object)array1));
            Assert.assertEquals((Object)new Tuple2((Object)-2, (Object)-5), (Object)twoFieldsSelector.getKey((Object)array2));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

