/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.sink.committables;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.flink.metrics.groups.SinkCommitterMetricGroup;
import org.apache.flink.runtime.metrics.groups.MetricsGroupTestUtils;
import org.apache.flink.streaming.api.connector.sink2.CommittableWithLineage;
import org.apache.flink.streaming.api.connector.sink2.CommittableWithLineageAssert;
import org.apache.flink.streaming.api.connector.sink2.SinkV2Assertions;
import org.apache.flink.streaming.runtime.operators.sink.committables.CommitRequestImpl;
import org.apache.flink.streaming.runtime.operators.sink.committables.SubtaskCommittableManager;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;

class SubtaskCommittableManagerTest {
    private static final SinkCommitterMetricGroup METRIC_GROUP = MetricsGroupTestUtils.mockCommitterMetricGroup();

    SubtaskCommittableManagerTest() {
    }

    @Test
    void testDrainCommittables() {
        SubtaskCommittableManager subtaskCommittableManager = new SubtaskCommittableManager(3, 1, 1L, METRIC_GROUP);
        CommittableWithLineage first = new CommittableWithLineage((Object)1, 1L, 1);
        CommittableWithLineage second = new CommittableWithLineage((Object)2, 1L, 1);
        CommittableWithLineage third = new CommittableWithLineage((Object)3, 1L, 1);
        Assertions.assertThat((Stream)subtaskCommittableManager.getPendingRequests()).hasSize(0);
        subtaskCommittableManager.add(first);
        subtaskCommittableManager.add(second);
        subtaskCommittableManager.add(third);
        Assertions.assertThat((Stream)subtaskCommittableManager.getPendingRequests()).hasSize(3);
        Assertions.assertThat((int)subtaskCommittableManager.getNumCommittables()).isEqualTo(3);
        Assertions.assertThat((int)subtaskCommittableManager.getNumDrained()).isEqualTo(0);
        Assertions.assertThat((boolean)subtaskCommittableManager.isFinished()).isFalse();
        Iterator requests = subtaskCommittableManager.getRequests().iterator();
        IntStream.range(0, 2).forEach(i -> ((CommitRequestImpl)requests.next()).setCommittedIfNoError());
        Assertions.assertThat((Stream)subtaskCommittableManager.getPendingRequests()).hasSize(1);
        Assertions.assertThat((int)subtaskCommittableManager.getNumCommittables()).isEqualTo(3);
        Assertions.assertThat((int)subtaskCommittableManager.getNumDrained()).isEqualTo(0);
        ListAssert committables = (ListAssert)Assertions.assertThat((List)subtaskCommittableManager.drainCommitted()).hasSize(2);
        ((CommittableWithLineageAssert)committables.element(0, Assertions.as(SinkV2Assertions.committableWithLineage()))).hasSubtaskId(1).hasCommittable(1).hasCheckpointId(1L);
        ((CommittableWithLineageAssert)committables.element(1, Assertions.as(SinkV2Assertions.committableWithLineage()))).hasSubtaskId(1).hasCommittable(2).hasCheckpointId(1L);
        Assertions.assertThat((int)subtaskCommittableManager.getNumFailed()).isEqualTo(0);
        Assertions.assertThat((List)subtaskCommittableManager.drainCommitted()).hasSize(0);
        ((CommitRequestImpl)requests.next()).signalFailedWithKnownReason((Throwable)new RuntimeException("Unused exception"));
        Assertions.assertThat((int)subtaskCommittableManager.getNumFailed()).isEqualTo(0);
        Assertions.assertThat((Stream)subtaskCommittableManager.getPendingRequests()).hasSize(0);
        Assertions.assertThat((int)subtaskCommittableManager.getNumCommittables()).isEqualTo(3);
        Assertions.assertThat((boolean)subtaskCommittableManager.isFinished()).isFalse();
        Assertions.assertThat((List)subtaskCommittableManager.drainCommitted()).hasSize(0);
        Assertions.assertThat((int)subtaskCommittableManager.getNumFailed()).isEqualTo(1);
        Assertions.assertThat((boolean)subtaskCommittableManager.isFinished()).isTrue();
    }

    @Test
    void testMerge() {
        SubtaskCommittableManager subtaskCommittableManager = new SubtaskCommittableManager(Collections.singletonList(new CommitRequestImpl((Object)1, METRIC_GROUP)), 5, 1, 2, 1, 2L, METRIC_GROUP);
        subtaskCommittableManager.merge(new SubtaskCommittableManager(Arrays.asList(new CommitRequestImpl((Object)2, METRIC_GROUP), new CommitRequestImpl((Object)3, METRIC_GROUP)), 10, 2, 3, 1, 2L, METRIC_GROUP));
        Assertions.assertThat((int)subtaskCommittableManager.getNumCommittables()).isEqualTo(11);
        Assertions.assertThat((int)subtaskCommittableManager.getNumDrained()).isEqualTo(3);
        Assertions.assertThat((boolean)subtaskCommittableManager.isFinished()).isFalse();
        Assertions.assertThat((int)subtaskCommittableManager.getNumFailed()).isEqualTo(5);
        Assertions.assertThat((Stream)subtaskCommittableManager.getPendingRequests()).hasSize(3);
    }
}

