/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.windowing;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.streaming.api.windowing.assigners.GlobalWindows;
import org.apache.flink.streaming.api.windowing.assigners.WindowAssigner;
import org.apache.flink.streaming.api.windowing.windows.GlobalWindow;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class GlobalWindowsTest
extends TestLogger {
    @Test
    public void testWindowAssignment() {
        WindowAssigner.WindowAssignerContext mockContext = (WindowAssigner.WindowAssignerContext)Mockito.mock(WindowAssigner.WindowAssignerContext.class);
        GlobalWindows assigner = GlobalWindows.create();
        Assert.assertThat((Object)assigner.assignWindows((Object)"String", 0L, mockContext), (Matcher)Matchers.contains((Object[])new GlobalWindow[]{GlobalWindow.get()}));
        Assert.assertThat((Object)assigner.assignWindows((Object)"String", 4999L, mockContext), (Matcher)Matchers.contains((Object[])new GlobalWindow[]{GlobalWindow.get()}));
        Assert.assertThat((Object)assigner.assignWindows((Object)"String", 5000L, mockContext), (Matcher)Matchers.contains((Object[])new GlobalWindow[]{GlobalWindow.get()}));
    }

    @Test
    public void testProperties() {
        GlobalWindows assigner = GlobalWindows.create();
        Assert.assertFalse((boolean)assigner.isEventTime());
        Assert.assertEquals((Object)new GlobalWindow.Serializer(), (Object)assigner.getWindowSerializer(new ExecutionConfig()));
        Assert.assertThat((Object)assigner.getDefaultTrigger(), (Matcher)Matchers.instanceOf(GlobalWindows.NeverTrigger.class));
    }
}

